Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Pod/Usage.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		bfast
Version:	0.7.0a
Release:	alt2_32
Summary:	Blat-like Fast Accurate Search Tool

License:	GPLv2 and MIT
URL:		https://github.com/nh13/BFAST
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch0:		%{name}-pthread-new.patch

BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	gcc
BuildRequires:	rpm-build-perl
BuildRequires:	zlib-devel
BuildRequires:	bzlib-devel
Source44: import.info


%description

BFAST facilitates the fast and accurate mapping of short reads to
reference sequences.  Some advantages of BFAST include:

Speed: enables billions of short reads to be mapped quickly.

Accuracy: A priori probabilities for mapping reads with defined set of variants.

An easy way to measurably tune accuracy at the expense of speed.

Specifically, BFAST was designed to facilitate whole-genome
resequencing, where mapping billions of short reads with variants is
of utmost importance.

BFAST supports both Illumina and ABI SOLiD data, as well as any other
Next-Generation Sequencing Technology (454, Helicos), with particular
emphasis on sensitivity towards errors, SNPs and especially
indels. Other algorithms take short-cuts by ignoring errors, certain
types of variants (indels), and even require further alignment, all to
be the "fastest" (but still not complete). BFAST is able to be tuned
to find variants regardless of the error-rate, polymorphism rate, or
other factors.


%prep
%setup -q
%patch0 -p1 

# Let configure honor CFLAGS
sed -i -e 's,^\(CFLAGS="${default_CFLAGS} ${extended_CFLAGS}"\),# \1,' configure.ac
# Regenerate butil/Makefile.in to retain
# balignmentscoredistribution_LDADD=-lpthread, otherwise the build fails with
# --as-needed in LDFLAGS, bug #1674691
autoreconf -fi

%build
# Package expects gnu89 inline semantics
%configure "CFLAGS=${CFLAGS} -fgnu89-inline"
%make_build


%install
%makeinstall_std

rm %{buildroot}/%{_docdir}/%{name}/LICENSE
rm %{buildroot}/%{_docdir}/%{name}/bfast-book.pdf


%files
%doc AUTHORS ChangeLog NEWS README
%doc manual/bfast-book.pdf
%doc --no-dereference LICENSE
%{_bindir}/balignmentscoredistribution
%{_bindir}/balignsim
%{_bindir}/bevalsim
%{_bindir}/bfast
%{_bindir}/bfast.resubmit.pl
%{_bindir}/bfast.submit.pl
%{_bindir}/bgeneratereads
%{_bindir}/bindexdist
%{_bindir}/bindexhist
%{_bindir}/bmfmerge
%{_bindir}/brepeat
%{_bindir}/btestindexes
%{_bindir}/ill2fastq.pl
%{_bindir}/solid2fastq


%changelog
