Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           bibutils
Version:        7.2
Release:        alt1_7
Summary:        Bibliography conversion tools

License:        GPLv2
URL:            http://sourceforge.net/p/bibutils/home/Bibutils/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}_%{version}_src.tgz

BuildRequires:  libxslt xsltproc
BuildRequires:  docbook-style-xsl
BuildRequires:  gcc
Source44: import.info

%description
The bibutils package converts between various bibliography
formats using a common MODS-format XML intermediate.


%package libs
Group: Other
Summary:        Bibutils library

%description libs
Bibutils library.


%package devel
Group: Other
Summary:        Development files for bibutils
Requires:       %{name}-libs = %{version}-%{release}

%description devel
Bibutils development files.


%prep
%setup -q -n %{name}_%{version}


%build
./configure \
    --install-dir %{buildroot}%{_bindir} \
    --install-lib %{buildroot}%{_libdir} \
    --dynamic
%make_build DISTRO_CFLAGS="%optflags" LDFLAGSIN="%{?__global_ldflags}"

xsltproc -o bibutils.1 --nonet /usr/share/sgml/docbook/xsl-stylesheets/manpages/docbook.xsl bibutils.dbk


%install
%makeinstall_std

mkdir -p %{buildroot}%{_includedir}/%{name}
cp -p lib/*.h %{buildroot}%{_includedir}/%{name}
mkdir -p %{buildroot}%{_libdir}/pkgconfig 
cp -p lib/%{name}.pc %{buildroot}%{_libdir}/pkgconfig
sed -i -e 's!\\!!g' -e 's!libdir=${prefix}/lib!libdir=%{_libdir}!' -e 's!${includedir}!${includedir}/%{name}!' %{buildroot}%{_libdir}/pkgconfig/%{name}.pc
mkdir -p %{buildroot}%{_mandir}/man1
cp -p %{name}.1 %{buildroot}%{_mandir}/man1

for i in $(cd %{buildroot}%{_bindir}; ls *); do
  ln -s bibutils.1 %{buildroot}%{_mandir}/man1/$i.1
done


%files
%doc ChangeLog
%{_bindir}/*
%{_mandir}/man1/*.1*


%files libs
%doc --no-dereference Copying
%{_libdir}/libbibutils.so.7
%{_libdir}/libbibutils.so.7.2


%files devel
%{_includedir}/%{name}
%{_libdir}/libbibutils.so
%{_libdir}/pkgconfig/%{name}.pc


%changelog
