# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/gtk-update-icon-cache libX11-devel nvidia-settings-devel pkgconfig(QtOpenGL) pkgconfig(gl) pkgconfig(liblircclient0) pkgconfig(lirc) texinfo
# END SourceDeps(oneline)
BuildRequires: libXNVCtrl-devel
%define fedora 37
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:    bino
Version: 1.6.8
Release: alt1_4
Summary: 3D video player
Group:   System/Base
License: GPLv3+
URL:     https://bino3d.org
Source0: https://bino3d.org/releases/%{name}-%{version}.tar.xz

# No libquadmath-devel on any other arch apart from x86
ExclusiveArch:  i686 x86_64

Requires:        icon-theme-hicolor

BuildRequires: automake
%if 0%{?fedora} && 0%{?fedora} > 35
BuildRequires: libavcodec-devel libavdevice-devel libavfilter-devel libavformat-devel libavutil-devel libpostproc-devel libswresample-devel libswscale-devel
%else
BuildRequires: libavcodec-devel libavdevice-devel libavfilter-devel libavformat-devel libavutil-devel libpostproc-devel libswresample-devel libswscale-devel
%endif
BuildRequires: gcc-c++
BuildRequires: libGLEW-devel
BuildRequires: libass-devel
BuildRequires: libopenal-devel
BuildRequires: qt5-base-devel
BuildRequires: libquadmath-devel
BuildRequires: gettext-tools libasprintf-devel
BuildRequires: makeinfo
BuildRequires: desktop-file-utils
Source44: import.info

%description
Bino is a 3D video player. It supports stereoscopic 3D video with a wide
variety of input and output formats. It also supports multi-display video
and it can be used for powerwalls, virtual reality installations and other
multi-projector setups.

%prep
%setup -q


# Removal of unneeded stuff
rm -rf pkg/macosx/*
touch pkg/macosx/Info.plist.in

%build
%if 0%{?fedora} && 0%{?fedora} > 35
export PKG_CONFIG_PATH="%{_libdir}/compat-ffmpeg4/pkgconfig"
%endif
%configure --disable-silent-rules --with-qt-version=5
%make_build V=1

%install
%makeinstall_std
rm -f %{buildroot}%{_infodir}/dir
rm -rf %{buildroot}%{_datadir}/doc

desktop-file-validate %{buildroot}%{_datadir}/applications/bino.desktop

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS ChangeLog NEWS README doc/*
%doc --no-dereference COPYING
%{_bindir}/bino
%{_infodir}/*
%{_mandir}/man1/*
%{_datadir}/applications/bino.desktop
%{_datadir}/icons/hicolor/*/apps/*

%changelog
