# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define version_of_biogenesis 0.9
%define version_of_color_mod 1.85
%define version_of_backup_button 1

Name: biogenesis
Summary: Artificial life program that simulates evolution of organisms
Version: %{version_of_biogenesis}.%{version_of_color_mod}.%{version_of_backup_button}
Release: alt1_3
Group: Sciences/Biology
License: GPLv2+
URL: http://biogenesis.sourceforge.net
# download from "https://sourceforge.net/projects/biogenesis/files/Color Mod" and repack
Source0: %{name}_src_%{version}.zip
Source1: https://sourceforge.net/projects/biogenesis/files/user%%20manuals/biogenesis_manual_0_9.zip
BuildRequires: ant
BuildRequires: java-devel-default /proc
BuildRequires: unzip
BuildRequires: jts >= 1.15.0
BuildArch: noarch
Requires: java
Requires: jts >= 1.15.0
Source44: import.info

%description
Biogenesis simulates in a visual fashion the processes involved in the
evolution of unicellular organisms at nature. It tries to be a didactic
approximation to the ideas of mutation or evolution and can be enjoyed
also as an entertainment. It's intended to serve as a support to show
students some basic biological facts.
It shows colored segment based organisms that mutate and evolve in a 2D
environment. Biogenesis is based on Primordial Life.

%prep
%setup -q -n %{name}_src_%{version}
# fix wrong-file-end-of-line-encoding
sed -i 's/\r//' ColorMod*/*.txt
# add manual
unzip %{SOURCE1}
rm -f %{name}_manual/copyright
rm -f %{name}_manual/gpl.txt

%build
export CLASSPATH=%{_javadir}/jts/jts-core.jar
export ANT_OPTS=-Dfile.encoding=UTF8
pushd src
%ant
popd

%install
pushd src
mkdir -p %{buildroot}%{_javadir}/%{name}
cp -a %{name}.jar %{buildroot}%{_javadir}/%{name}/
mkdir -p %{buildroot}%{_bindir}
install -m 755 launch_%{name} %{buildroot}%{_bindir}/%{name}
mkdir -p %{buildroot}%{_datadir}/applications
install -m 644 %{name}.desktop %{buildroot}%{_datadir}/applications/
mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m 644 %{name}.png %{buildroot}%{_datadir}/pixmaps/
mkdir -p %{buildroot}%{_mandir}/man1
install -m 644 %{name}.1 %{buildroot}%{_mandir}/man1/
popd

%files
%doc src/changelog* %{name}_manual ColorMod*/*.txt ColorMod*/copyright
%{_bindir}/%{name}
%{_javadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%{_mandir}/man1/*


%changelog
