Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/readelf gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		biosdevname
Version:	0.7.3
Release:	alt1_8
Summary:	Udev helper for naming devices per BIOS names
License:	GPLv2
URL:		http://linux.dell.com/files/%{name}
# SMBIOS only exists on these arches.  It's also likely that other
# arches don't expect the PCI bus to be sorted breadth-first, or of
# so, there haven't been any comments about that on LKML.
ExclusiveArch:	%{ix86} x86_64
Source0:	http://linux.dell.com/files/%{name}/%{name}-%{version}/%{name}-%{version}.tar.gz

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gcc
BuildRequires:  libpci-devel
BuildRequires:  zlib-devel

Patch1: 0001-Disable-biosdevname-by-default.patch
Patch2: 0002-Place-udev-rules-to-usr-lib.patch
Source44: import.info

%description
biosdevname in its simplest form takes a kernel device name as an
argument, and returns the BIOS-given name it "should" be.  This is necessary
on systems where the BIOS name for a given device (e.g. the label on
the chassis is "Gb1") doesn't map directly and obviously to the kernel
name (e.g. eth0).

%prep
%setup -q
%patch1 -p1
%patch2 -p1

%build
autoreconf -fvi
%configure --prefix=%{_prefix}
%make_build

%install
make install install-data DESTDIR=%{buildroot}
mkdir -p %buildroot/lib
mv %buildroot/usr/lib/udev* %buildroot/lib

%files
%doc COPYING README
%{_sbindir}/%{name}
%{_udevrulesdir}/*.rules
%{_mandir}/man1/%{name}.1*

%changelog
