# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: A server process which provides boot information to diskless clients
Name: bootparamd
Version: 0.17
Release: alt2_46
License: BSD
Group: System/Servers
Source: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/netkit-%{name}-%{version}.tar.gz
Source1: bootparamd.service
Patch: bootparamd-manpage-63567.patch
Patch1: bootparamd-resolver.patch
Patch2: bootparamd-debug.patch
Patch3: bootparamd.fast-dns.patch
Patch4: bootparamd-resolver-fix.patch
Patch5: bootparamd-get-router.patch
Patch6: bootparamd-err.patch
Patch7: bootparamd-byteorder.patch
Patch8: bootparamd-getopt.patch

BuildRequires: perl

Requires: rpcbind

%description
The bootparamd process provides bootparamd, a server process which
provides the information needed by diskless clients in order for them
to successfully boot.  Bootparamd looks first in /etc/bootparams for an
entry for that particular client; if a local bootparams file doesn't
exist, it looks at the appropriate Network Information Service (NIS)
map.  Some network boot loaders (notably Sun's) rely on special boot
server code on the server, in addition to the RARP and TFTP servers.
This bootparamd server process is compatible with SunOS bootparam clients
and servers which need that boot server code.

You should install bootparamd if you need to provide boot information to
diskless clients on your network.

%prep
%setup -q -n netkit-%{name}-%{version}
%patch -p1
%patch1 -p1
%patch2 -p1 -b .unblocksignals
%patch3 -p1
%patch4 -p1
%patch5 -p1 -b .router
%patch6 -p1 -b .err
%patch7 -p1 -b .byteorder
%patch8 -p1 -b .getopt

%build
sh configure --with-c-compiler=gcc
perl -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -D_BSD_SOURCE \$(f_PIE),;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    s,^LDFLAGS=,LDFLAGS=-pie,;
    ' MCONFIG
%ifarch s390 s390x 
export f_PIE="-fPIE"
%else
export f_PIE="-fpie"
%endif
%make_build

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}/man{1,8}
mkdir -p %{buildroot}%{_sbindir}

mkdir -p "${RPM_BUILD_ROOT}%{_unitdir}/"
cp -a "%{SOURCE1}" "${RPM_BUILD_ROOT}%{_unitdir}/"

make INSTALLROOT=%{buildroot} install

%post
%post_service bootparamd

%preun
%preun_service bootparamd

%files
%{_sbindir}/rpc.bootparamd
%{_bindir}/callbootd
%{_mandir}/man8/rpc.bootparamd.*
%{_mandir}/man8/bootparamd.*
%{_unitdir}/*

%changelog
