%filter_from_requires /^.hbb/d
Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: perl(Sys/Info.pm) perl(Sys/Info/Constants.pm) python3-devel unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		bowtie
Version:	1.3.1
Release:	alt1_2
Summary:	An ultrafast, memory-efficient short read aligner

# bowite: Artistic 2.0
# tinythread.{h,cpp}: zlib
License:	Artistic 2.0 and zlib
URL:		http://bowtie-bio.sourceforge.net/index.shtml
Source0:	http://downloads.sourceforge.net/%{name}-bio/%{name}-%{version}-src.zip
# git clone https://github.com/BenLangmead/bowtie.git
# cd bowtie
# git checkout v1.3.1
# tar czvf bowtie-1.3.1-tests.tgz scripts/test/
Source1:	bowtie-%{version}-tests.tgz
# Remove perl-Sys-Info module depenency, as it does not exist on Fedora.
Patch1:		bowtie-test-remove-perl-Sys-Info-dep.patch
Requires:	python3
BuildRequires:	gcc-c++
BuildRequires:	coreutils
BuildRequires:	perl-devel
BuildRequires:	perl(Clone.pm)
BuildRequires:	perl(Data/Dumper.pm)
BuildRequires:	perl(FindBin.pm)
BuildRequires:	perl(Getopt/Long.pm)
BuildRequires:	perl(Test/Deep.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	python3
BuildRequires:	tbb-devel
BuildRequires:	zlib-devel
# 32-bit CPU architectures are not supported for bowtie version >= 1.1.0.
# https://github.com/BenLangmead/bowtie/commit/5f90d3fdad97a8181ddaa96c64faeef1f2b6edf9
ExcludeArch: i686 armv7hl

# Bundled libraries
# https://fedoraproject.org/wiki/Bundled_Libraries?rd=Packaging:Bundled_Libraries#Requirement_if_you_bundle
# TinyThread++
# https://tinythreadpp.bitsnbites.eu/
# https://gitorious.org/tinythread/tinythreadpp
Provides: bundled(tiny-thread) = 1.1
Source44: import.info
ExcludeArch: %ix86 %arm


%description

Bowtie, an ultrafast, memory-efficient short read aligner for short
DNA sequences (reads) from next-gen sequencers. Please cite: Langmead
B, et al. Ultrafast and memory-efficient alignment of short DNA
sequences to the human genome. Genome Biol 10:R25.

%prep
%setup -q -n %{name}-%{version}-src

# Remove the directory to avoid building bowtie with bundled libraries.
rm -rf third_party/

# Fix shebang to use system python3.
for file in $(find . -name "*.py") bowtie bowtie-*; do
  sed -E -i '1s|/usr/bin/env python[3]?|%{__python3}|' "${file}"
done


%build
# Set flags considering bowtie2's testing cases for each architecture.
# https://github.com/BenLangmead/bowtie2/blob/master/.travis.yml
# https://github.com/BenLangmead/bowtie/pull/102
%ifnarch x86_64
export POPCNT_CAPABILITY=0
%endif

# A workaround to pass the tests.
# Cline paired 2 (fw:1, sam:1) test aborted with -Wp,-D_GLIBCXX_ASSERTIONS
# https://github.com/BenLangmead/bowtie/issues/136
CFLAGS=$(echo "${CFLAGS}" | sed -e 's/-Wp,-D_GLIBCXX_ASSERTIONS//')
export CFLAGS
CXXFLAGS=$(echo "${CXXFLAGS}" | sed -e 's/-Wp,-D_GLIBCXX_ASSERTIONS//')
export CXXFLAGS

# Set debug flag "-g" to prevent the error
# "Empty %%files file debugsourcefiles.list".
%make_build allall EXTRA_FLAGS="-g"


%install
%makeinstall_std prefix="%{_prefix}"

mkdir -p %{buildroot}/%{_datadir}/bowtie
cp -a reads %{buildroot}/%{_datadir}/bowtie/
cp -a indexes %{buildroot}/%{_datadir}/bowtie/
cp -a genomes %{buildroot}/%{_datadir}/bowtie/
cp -a scripts %{buildroot}/%{_datadir}/bowtie/

# Install bowtie-*-debug commands used by `bowtie --debug`.
for cmd in bowtie-*-debug; do
  cp -p "${cmd}" %{buildroot}/%{_bindir}/
done

%check
for cmd in bowtie bowtie-build bowtie-inspect; do
  ./"${cmd}" --version | grep 'version %{version}'
done

tar xzvf %{SOURCE1}
cat %{PATCH1} | patch -p1

# See Makefile simple-test target.
scripts/test/simple_tests.pl --bowtie=./bowtie --bowtie-build=./bowtie-build


%files
%doc --no-dereference LICENSE
%doc MANUAL NEWS VERSION AUTHORS TUTORIAL doc/manual.html
%doc MANUAL NEWS VERSION AUTHORS TUTORIAL doc/style.css
%dir %{_datadir}/bowtie
%{_bindir}/bowtie
%{_bindir}/bowtie-align-l
%{_bindir}/bowtie-align-l-debug
%{_bindir}/bowtie-align-s
%{_bindir}/bowtie-align-s-debug
%{_bindir}/bowtie-build
%{_bindir}/bowtie-build-l
%{_bindir}/bowtie-build-l-debug
%{_bindir}/bowtie-build-s
%{_bindir}/bowtie-build-s-debug
%{_bindir}/bowtie-inspect
%{_bindir}/bowtie-inspect-l
%{_bindir}/bowtie-inspect-l-debug
%{_bindir}/bowtie-inspect-s
%{_bindir}/bowtie-inspect-s-debug
%{_datadir}/bowtie/genomes
%{_datadir}/bowtie/indexes
%{_datadir}/bowtie/reads
%{_datadir}/bowtie/scripts


%changelog
