# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libglvnd-devel
# END SourceDeps(oneline)
BuildRequires: libXext-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum	A 3D chess game inspired by Battle Chess

Name:		brutalchess
Version:	0.5.2
Release:	alt1_20
Summary:	%{sum}
License:	GPLv2+
Group:		Games/Boards
URL:		https://sourceforge.net/projects/brutalchess/
Source0:	%{name}-alpha-%{version}-src.tar.bz2
Source11:	%{name}-16x16.png
Source12:	%{name}-32x32.png
Source13:	%{name}-48x48.png
# Fedora patches:
Patch0:         https://sf.net/p/%{name}/patches/8/attachment/%{name}-freetype2.patch
# fonts: https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=584416
Patch1:         https://sf.net/p/%{name}/patches/7/attachment/%{name}-fonts.diff
# PGN resembling console output, https://sourceforge.net/p/brutalchess/patches/3
Patch2:         https://sf.net/p/%{name}/patches/_discuss/thread/96f1a752/0dc4/attachment/pgn-moveprint.diff
# Fix -l option, https://sourceforge.net/p/brutalchess/patches/2
Patch3:         https://sf.net/p/%{name}/patches/_discuss/thread/b91b1843/e6b7/attachment/fix-player2opt.diff
Patch10:        https://slackbuilds.org/slackbuilds/14.1/games/%{name}/%{name}-%{version}-fix-FTBFS.patch
Patch11:        https://slackbuilds.org/slackbuilds/14.1/games/%{name}/%{name}-%{version}-gcc4.3.patch
Patch12:        https://slackbuilds.org/slackbuilds/14.1/games/%{name}/%{name}-%{version}-gcc4.7.patch
# Mageia patches:
Patch102:	%{name}-%{version}-use-own-fonts.patch
Patch103:	%{name}-%{version}-linkage.patch
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(SDL_image)
BuildRequires:	libGL-devel
BuildRequires:	pkgconfig(glu)
BuildRequires:	libfreetype-devel
BuildRequires:	desktop-file-utils
Requires:	fonts-ttf-dejavu
Source44: import.info

%description
Brutal Chess features full 3D graphics, an advanced particle engine, and
several different levels of intelligent AI, inspired by the once popular
"Battle Chess" released by Interplay circa 1988.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch102 -p1
%patch103 -p1


%build
%add_optflags -Wno-error=return-type
autoreconf -fi
%configure	--bindir=%{_gamesbindir} \
		--datadir=%{_gamesdatadir}
%make_build

%install
%makeinstall_std

# we use system default font via patch2
rm -fr %{buildroot}%{_gamesdatadir}/%{name}/fonts

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Brutal Chess
Comment=%{sum}
Exec=%{_gamesbindir}/%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Game;StrategyGame;BoardGame;
EOF

install -m644 %{_sourcedir}/%{name}-16x16.png -D %{buildroot}%{_miconsdir}/%{name}.png
install -m644 %{_sourcedir}/%{name}-32x32.png -D %{buildroot}%_niconsdir/%{name}.png
install -m644 %{_sourcedir}/%{name}-48x48.png -D %{buildroot}%{_liconsdir}/%{name}.png
rm -fr %{buildroot}%{_defaultdocdir}/%name

%files
%doc AUTHORS ChangeLog NEWS README
%{_gamesbindir}/%{name}
%{_libexecdir}/md3view
%{_libexecdir}/objview
%{_gamesdatadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_miconsdir}/%{name}.png
%_niconsdir/%{name}.png
%{_liconsdir}/%{name}.png


%changelog
