Group: Development/Tools
Name:           bunny
Version:        0.93
Release:        alt2_20
Summary:        Instrumented C code security fuzzer
License:        ASL 2.0
URL:            http://code.google.com/p/%{name}-the-fuzzer/
Source0:        http://%{name}-the-fuzzer.googlecode.com/files/%{name}-%{version}.tgz
BuildRequires:  libssl-devel
# Package dynamically re-writes assembly code
ExclusiveArch:  %{ix86} x86_64
Provides:       %{name}-the-fuzzer
Source44: import.info

%description
A closed loop, high-performance, general purpose protocol-blind fuzzer
for C programs.  Uses compiler-level integration to seamlessly inject
precise and reliable instrumentation hooks into the traced
program. These hooks enable the fuzzer to receive real-time feedback
on changes to the function call path, call parameters, and return
values in response to variations in input data.  This architecture
makes it possible to significantly improve the coverage of the testing
process without a noticeable performance impact usually associated
with other attempts to peek into run-time internals.

%prep
%setup -qn %{name}

%build
make %{?_smp_mflags} CFLAGS="%{optflags}"

%install
mkdir -p %{buildroot}%{_bindir}
install -p -m 755 %{name}-exec %{buildroot}%{_bindir}/
install -p -m 755 %{name}-flow %{buildroot}%{_bindir}/
install -p -m 755 %{name}-gcc %{buildroot}%{_bindir}/
install -p -m 755 %{name}-main %{buildroot}%{_bindir}/
install -p -m 755 %{name}-trace %{buildroot}%{_bindir}/

%check
make test1
make test2
make test3

%files
%doc CHANGES COPYING README
%{_bindir}/%{name}-exec
%{_bindir}/%{name}-flow
%{_bindir}/%{name}-gcc
%{_bindir}/%{name}-main
%{_bindir}/%{name}-trace

%changelog
