Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(GD/Graph.pm) perl(GD/Graph/bars.pm) perl(GD/Graph/colour.pm) perl(GD/Graph/utils.pm) perl(Switch.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Summary:        Analyzer and report generator for web proxy servers like Squid
Name:           calamaris
Version:        2.99.4.7
Release:        alt1_7
License:        (GPL-1.0-or-later OR Artistic-1.0-Perl) AND GPL-2.0-or-later
URL:            https://cord.de/calamaris-english
Source0:        https://cord.de/files/calamaris/%{name}-%{version}.tar.gz
Patch0:         calamaris-2.99.4.7-use-lib.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
Requires:       perl(NetAddr/IP.pm)
Source44: import.info
%filter_from_requires /^perl(ident.pm)/d

%description
Calamaris is used to produce statistical output from web proxy servers
like Squid, NetCache, Inktomi Traffic Server, Oops! proxy server, Compaq
TaskSmart, Cisco Content Engines, iPlanet Proxy Server or related proxy
log files. The resulting output can be ASCII or HTML with or without
graphics and with or without frames. It is possible to cache calculated
data in a file to use them in later runs.

%prep
%setup -q
%patch0 -p1 -b .use-lib
for file in *.use-lib; do touch -c -r ${file} ${file%.use-lib}; done

%build

%install
install -D -p -m 0755 %{name} $RPM_BUILD_ROOT%{_bindir}/%{name}
install -D -p -m 0644 %{name}.1 $RPM_BUILD_ROOT%{_mandir}/man1/%{name}.1
for file in *.pm; do
  install -D -p -m 0644 ${file} $RPM_BUILD_ROOT%{perl_vendor_privlib}/%{name}/${file}
done

# Convert files from ISO-8859-1 to UTF-8
for file in CONTRIBUTORS EXAMPLES; do
  iconv -f iso-8859-1 -t utf-8 -o ${file}.utf8 ${file}
  touch -c -r ${file} ${file}.utf8; mv -f ${file}.utf8 ${file}
done

%files
%doc --no-dereference COPYRIGHT
%doc CHANGES CONTRIBUTORS EXAMPLES EXAMPLES.v3 README
%{_bindir}/%{name}
%{perl_vendor_privlib}/%{name}/
%{_mandir}/man1/%{name}.1*

%changelog
