# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# filter out bogus auto-requires
%global __requires_exclude ^/usr/bin/csh$

Name:    cdsclient
Version: 3.84
Release: alt1_4
Summary: Query astronomical catalogues from the command line

Group:   Sciences/Astronomy
License: GPLv2

URL:     http://cdsarc.u-strasbg.fr/doc/cdsclient.html
Source0: ftp://cdsarc.u-strasbg.fr/pub/sw/%{name}-%{version}.tar.gz
# Patch to get useful debuginfo. strip was called in Makefile before and compiler
# flags were ignored, submitted upstream by email
Patch0:         fix_makefile_debuginfo.patch

#wwwget is not build in this version
Requires: wget
Source44: import.info

%description
The cdsclient package is a set of C and shell routines which can be
built on Unix stations or PCs running Linux, which once compiled
allow to query some databases located at CDS or on mirrors over the
network.


%prep
%setup -q
%patch0 -p1



%build
%configure
%make_build

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}

%makeinstall_std PREFIX=%{buildroot}%{_prefix} MANDIR=%{buildroot}%{_mandir}

rm -f %{buildroot}%{_prefix}/versions
rm -f %{buildroot}%{_mandir}/mantex/aclient.tex
rm -f %{buildroot}%{_bindir}/find_cats.gz
install -d %{buildroot}%{_datadir}/cdsclient
mv %{buildroot}%{_bindir}/abibcode.awk %{buildroot}%{_datadir}/cdsclient/abibcode.awk

%files
%doc aclient.tex
%{_bindir}/abibcode
%{_bindir}/aclient
%{_bindir}/aclient_cgi
%{_bindir}/Detex
%{_bindir}/catcat
%{_bindir}/find*
#commented upstream
#%%{_bindir}/wwwget
%{_bindir}/lscat
%{_bindir}/sesame
%{_bindir}/simbib
%{_bindir}/simref
%{_bindir}/vizquery
%{_datadir}/cdsclient/abibcode.awk
%{_mandir}/man1/aclient.1*
%{_mandir}/man1/wwwget.1*
%{_mandir}/man3/sk.3*


%changelog
