Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           celt071
Version:        0.7.1
Release:        alt1_20
Summary:        An audio codec for use in low-delay speech and audio communication

License:        BSD and GPLv2+
# Files without license header are confirmed to be BSD. Will be fixed in later release
# http://lists.xiph.org/pipermail/celt-dev/2009-February/000063.html
URL:            http://www.celt-codec.org/
Source0:        http://downloads.us.xiph.org/releases/celt/celt-%{version}.tar.gz
Source1:        %{name}.pc.in
Patch0:         %{name}-append-version-suffix.patch
BuildRequires:  libogg-devel
BuildRequires:  libtool
Source44: import.info

%description
CELT (Constrained Energy Lapped Transform) is an ultra-low delay audio
codec designed for realtime transmission of high quality speech and audio.
This is meant to close the gap between traditional speech codecs
(such as Speex) and traditional audio codecs (such as Vorbis).

The CELT bitstream format is not yet stable, this package is a special
version of 0.7.1 that has the same bitstream format, but symbols and files
renamed from 'celt*' to 'celt071*' so that it is parallel installable with
the normal celt for packages requiring this particular bitstream format.

%package devel
Group: Development/Other
Summary: Development package for %{name}
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q -n celt-%{version}
cp %{SOURCE1} .
%patch0 -p1
autoreconf -f -i

%build
%configure --disable-static
# Remove rpath as per https://fedoraproject.org/wiki/Packaging/Guidelines#Beware_of_Rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

%make_build

%install
make install DESTDIR=%{buildroot}
rm %{buildroot}/%{_libdir}/libcelt071.la



%files
%doc COPYING README TODO
%{_bindir}/celtenc071
%{_bindir}/celtdec071
%{_libdir}/libcelt071.so.0
%{_libdir}/libcelt071.so.0.0.0

%files devel
%doc COPYING README
%{_includedir}/celt071
%{_libdir}/pkgconfig/celt071.pc
%{_libdir}/libcelt071.so

%changelog
