Group: Databases
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Pg.pm) perl(DBI.pm) perl(Date/Parse.pm) perl(File/Comments.pm) perl(Module/Signature.pm) perl(Perl/Critic.pm) perl(Pod/Spell.pm) perl(Pod/Text.pm) perl(Pod/Usage.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/SpellChecker.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:    PostgreSQL monitoring script
Name:       check_postgres
Version:    2.25.0
Release:    alt2_10
License:    BSD
URL:        https://bucardo.org/check_postgres/
BuildArch:  noarch

Source0:    https://github.com/bucardo/%{name}/releases/download/%{version}/%{name}-%{version}.tar.gz

Patch0:     0001-Update-doc-and-fix-missing-title-close-tag.patch
Patch1:     0002-Make-sure-our-temp-filehandles-are-doing-UTF-8.patch
Patch2:     0004-Fix-check_replication_slots-on-recently-promoted-ser.patch

BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
Source44: import.info

%description
Script for checking the state of one or more Postgres databases and reporting
back in a Nagios-friendly manner. It is also used for MRTG.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}

%if 0%{?rhel} == 7
# When building noarch on Koji you have no guaranteed how _libdir expands:
rm -fr %{buildroot}%{_prefix}/lib*
# Not happening automatically:
sed -i -e 's|^#!/usr/bin/env perl|#!/usr/bin/perl|g' %{buildroot}%{_bindir}/%{name}.pl
%endif

# Fix permissions
chmod 755 %{buildroot}%{_bindir}/%{name}.pl
chmod 644 %{buildroot}%{_mandir}/man1/%{name}.*

# Fix man page filename
mv %{buildroot}%{_mandir}/man1/%{name}.1p %{buildroot}%{_mandir}/man1/%{name}.pl.1

%files
%doc --no-dereference LICENSE
%doc %{name}.pl.html README.md TODO
%{_mandir}/man1/%{name}.pl.1*
%{_bindir}/%{name}.pl

%changelog
