# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fversion 1.6.2


Summary:   CheckInstall installations tracker
Name:      checkinstall
Version:   1.6.2.16
Release:   alt1_19
License:   GPLv2+
Group:     System/Configuration/Packaging
#gw git snapshot
Source:    http://checkinstall.izto.org/files/source/%{name}-%{fversion}.tar.gz
Patch0:    checkinstall-mdv-fix-paths.patch
Patch2:    checkinstall-1.6.1-mdv-rpm-version-check.patch
Patch3:    installwatch-glibc_minor.patch
Patch4:    checkinstall-mdv-rpm-set-buildroot.patch
Patch5:    checkinstall-1.6.2-mga-test-open.patch
# Debian patches
Patch6:    checkinstall-1.6.1-deb-mdv-build-with-new-glibc.patch
Patch7:    checkinstall-1.6.2-cflags.patch
Patch8:    checkinstall-1.6.2-deb-0013-fix-installcheck-tests.patch
Patch9:    checkinstall-1.6.2-deb-0014-fix-xstat64.patch
Patch10:   checkinstall-1.6.2-deb-0015-add-renameat2.patch
Patch11:   checkinstall-1.6.2-deb-0016-Define-_STAT_VER-_MKNOD_VER-locally-dropped-in-glibc.patch
Url:       https://asic-linux.com.mx/~izto/checkinstall/
Requires:  rpm-build
Source44: import.info

%description
CheckInstall keeps track of all the files created or modified by your
installation script ("make install" "make install_modules", "setup", etc),
builds a standard binary package and installs it in your system giving
you the ability to uninstall it with your distribution's standard
package management utilities.


%prep
%setup -q -n %{name}-%{fversion}
%patch0 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1


%build
%make_build CFLAGS="%{optflags}" LD="gcc" LDFLAGS=" -nostdlib"

%install
install -D -m 755 checkinstall %{buildroot}/%{_bindir}/checkinstall
install -D -m 755 makepak %{buildroot}/%{_sbindir}/makepak
install -m 755 installwatch/installwatch %{buildroot}/%{_bindir}
install -D -m 755 installwatch/installwatch.so %{buildroot}/%{_libdir}/checkinstall/installwatch.so
install -m 755 checkinstallrc-dist %{buildroot}/%{_libdir}/checkinstall/checkinstallrc
install -D -m 644 locale/checkinstall-es.mo %{buildroot}%{_libdir}/checkinstall/locale/es/LC_MESSAGES/checkinstall.mo
perl -pi -e "s!#PREFIX#!%_prefix!" %{buildroot}%{_bindir}/installwatch
perl -pi -e "s!/lib/!/%_lib/!" %{buildroot}%{_bindir}/*

%check
mkdir -p "${PWD}/install/lib/" 
# hack to fake that it was installed like the install section above
ln -s . "${PWD}/install/lib/checkinstall"
%make_build CFLAGS="%{optflags}" LD="gcc" LDFLAGS="" PREFIX="${PWD}/install" -C installwatch test

%files
%doc README RELNOTES BUGS TODO CREDITS
%{_bindir}/installwatch
%{_bindir}/checkinstall
%{_sbindir}/makepak
%dir %{_libdir}/checkinstall/
%{_libdir}/checkinstall/checkinstallrc
%{_libdir}/checkinstall/installwatch.so
%lang(es) %{_libdir}/checkinstall/locale/es
%dir %{_libdir}/checkinstall/locale/


%changelog
