# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 1.5.8
%define url_ver	%(echo %{version}|sed 's/[.]/./g')

Name:		chessx
Version:	1.5.8
Release:	alt1_3
Summary:	An Open Source chess database
License:	GPLv2
Group:		Games/Boards
URL:		https://chessx.sourceforge.io/
Source0:	https://sourceforge.net/projects/chessx/files/%{name}/%{version}/%{name}-%{url_ver}.tgz
# upstream patches
# https://github.com/Isarhamster/chessx/pull/61
Patch002:	0002-Fix-install-path-of-icons-on-Linux.patch
# https://github.com/Isarhamster/chessx/pull/63
Patch003:	0003-Allow-linking-against-system-libraries-via-pkg-confi.patch
Patch004:	0004-Simplified-About-Dialog.patch
# mageia patches
Patch10:	chessx-mga-install-lang-and-data-files.patch

BuildRequires:	pkgconfig(Qt5Concurrent)
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Help)
BuildRequires:	pkgconfig(Qt5Multimedia)
BuildRequires:	pkgconfig(Qt5MultimediaWidgets)
BuildRequires:	pkgconfig(Qt5Network)
BuildRequires:	pkgconfig(Qt5OpenGL)
BuildRequires:	pkgconfig(Qt5PrintSupport)
BuildRequires:	pkgconfig(Qt5Svg)
BuildRequires:	pkgconfig(Qt5Test)
BuildRequires:	pkgconfig(Qt5TextToSpeech)
BuildRequires:	pkgconfig(Qt5Widgets)
BuildRequires:	pkgconfig(Qt5Xml)
BuildRequires:	pkgconfig(quazip1-qt5)

# Bundles part of scid 1.0 (https://sourceforge.net/projects/scid/)
Provides:	bundled(scid) = 1.0
Source44: import.info

%description
ChessX is an Open Source chess database. With ChessX you can operate on your
collection of chess games in many ways:
browse, edit, add, organize, analyze, etc.

%prep
%setup -q
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch10 -p1


# Ensure bundled quazip code is not used
rm -rf src/quazip

%build
%{_qt5_bindir}/lrelease i18n/*.ts
%qmake_qt5 -r CONFIG+=link_pkgconfig CONFIG+=speech
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

%files
%doc --no-dereference COPYING.md
%doc README.md ChangeLog.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_metainfodir}/io.sourceforge.ChessX.metainfo.xml


%changelog
