# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libheif-devel pkgconfig(Magick++) unzip zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	oname CImg
%define	debug_package %{nil}

Summary:	Tools for advanced image processing
Name:		cimg
Version:	3.2.0
Release:	alt1_1
License:	CeCiLLv2
Group:		Graphics
URL:		https://cimg.eu/
Source0:	https://cimg.eu/files/CImg_%{version}.zip
BuildRequires:	pkgconfig(x11)
BuildRequires:	pkgconfig(OpenEXR)
BuildRequires:	pkgconfig(libpng)
BuildRequires:	pkgconfig(libjpeg)
BuildRequires:	pkgconfig(libtiff-4)
BuildRequires:	pkgconfig(fftw3)
BuildRequires:	doxygen
Source44: import.info

%description
Image manipulation tools based on the CImg library, including the
greycstoration noise reduction tool.

%package   devel
Summary:   Library for advanced image processing (development files)
Group:     Development/C++
Requires:  pkgconfig(OpenEXR)
Provides:  CImg-devel = %{version}-%{release} 

%description devel
The CImg Library is a C++ toolkit providing simple classes and functions to
load, save, process and display images in your own C++ code. It consists
only of a single header file CImg.h that must be included in your program
source. It contains useful image processing algorithms for loading/saving,
resizing/rotating, filtering, object drawing (text, lines, faces,
ellipses, ...), etc.

Images are instanciated by a class able to represent images up to 4-dimension
wide (from 1-D scalar signals to 3-D volumes of vector-valued pixels), with
template pixel types. It depends on a minimal number of libraries: you can
compile it with only standard C libraries. No need for exotic libraries and
complex dependencies.

%prep
%setup -q -n %{oname}-%{version}

%build
pushd examples
%make_build olinux
popd

%install
mkdir -p %{buildroot}%{_bindir}
pushd examples
mv captcha %{buildroot}%{_bindir}
mv CImg_demo %{buildroot}%{_bindir}
mv curve_editor2d %{buildroot}%{_bindir}
mv dtmri_view3d %{buildroot}%{_bindir}
mv edge_explorer2d %{buildroot}%{_bindir}
mv fade_images %{buildroot}%{_bindir}
mv gaussian_fit1d %{buildroot}%{_bindir}
mv generate_loop_macros %{buildroot}%{_bindir}
mv hough_transform2d %{buildroot}%{_bindir}
mv image2ascii %{buildroot}%{_bindir}
mv image_registration2d %{buildroot}%{_bindir}
mv image_surface3d %{buildroot}%{_bindir}
mv jawbreaker %{buildroot}%{_bindir}
mv mcf_levelsets2d %{buildroot}%{_bindir}
mv mcf_levelsets3d %{buildroot}%{_bindir}
mv odykill %{buildroot}%{_bindir}
mv pde_heatflow2d %{buildroot}%{_bindir}
mv pde_TschumperleDeriche2d %{buildroot}%{_bindir}
mv plotter1d %{buildroot}%{_bindir}
mv radon_transform2d %{buildroot}%{_bindir}
mv scene3d %{buildroot}%{_bindir}
mv spherical_function3d %{buildroot}%{_bindir}
mv tetris %{buildroot}%{_bindir}
mv tron %{buildroot}%{_bindir}
mv tutorial %{buildroot}%{_bindir}
mv use_chlpca %{buildroot}%{_bindir}
mv use_draw_gradient %{buildroot}%{_bindir}
mv use_nlmeans %{buildroot}%{_bindir}
mv use_RGBclass %{buildroot}%{_bindir}
mv use_skeleton %{buildroot}%{_bindir}
mv wavelet_atrous %{buildroot}%{_bindir}
popd

mkdir -p %{buildroot}%{_includedir}/%{oname}
mv plugins %{buildroot}%{_includedir}/%{oname}
mv %{oname}.h %{buildroot}%{_includedir}/%{oname}
ln -s %{oname}/%{oname}.h %{oname}.h
mv %{oname}.h %{buildroot}%{_includedir}

%files
%doc README.txt
%doc --no-dereference Licence*
%{_bindir}/*

%files devel
%{_includedir}/%{oname}*
%doc README.txt Licence_CeCILL* examples


%changelog
