Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          ckeditor
Version:       4.22.1
Release:       alt1_3
Summary:       WYSIWYG text editor to be used inside web pages

License:       GPLv2+ or LGPLv2+ or MPLv1.1
URL:           http://ckeditor.com/

Source0:       http://download.cksource.com/CKEditor/CKEditor/CKEditor%%20%{version}/ckeditor_%{version}_standard.tar.gz

BuildArch:     noarch
BuildRequires: web-assets-devel

Requires:      web-assets-filesystem
Source44: import.info


%description
CKEditor is a text editor to be used inside web pages. It's a WYSIWYG editor,
which means that the text being edited on it looks as similar as possible to
the results users have when publishing it. It brings to the web common editing
features found on desktop editing applications like Microsoft Word and
OpenOffice.


%package samples
Group: Documentation
Summary:  Samples for %{name}
Requires: %{name} = %{version}-%{release}

%description samples
%{summary}.


%prep
%setup -qn %{name}

: Licenses
mkdir -p .rpm/{licenses,docs}
for LICENSE_FILE in $(find . -type f -name 'LICENSE*')
do
    DIR=$(dirname $LICENSE_FILE)
    mkdir -p .rpm/licenses/$DIR
    mv $LICENSE_FILE .rpm/licenses/$DIR/
done

: Docs
for DOC_FILE in $(find . -type f -name '*.md' -not -name 'LICENSE*')
do
    DIR=$(dirname $DOC_FILE)
    mkdir -p .rpm/docs/$DIR
    mv $DOC_FILE .rpm/docs/$DIR/
done

: wrong-file-end-of-line-encoding
find .rpm -type f -print0 | xargs -0 sed -i 's/\r$//'

: Delete bundled flash files
rm -rf samples/old/htmlwriter/{assets,outputforflash.html}


%build
# Empty build section, nothing to build


%install
mkdir -p %{buildroot}%{_webassetdir}/%{name}
cp -pr * %{buildroot}%{_webassetdir}/%{name}/

: Compat filesystem
mkdir -p %{buildroot}/%{_datadir}
ln -s %{_webassetdir}/%{name} %{buildroot}/%{_datadir}/%{name}
for rpm404_ghost in %{_datadir}/%{name}.rpmmoved
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done



# https://fedoraproject.org/wiki/Packaging:Directory_Replacement#Scriptlet_to_replace_a_directory
%files
%{!?_licensedir:%global license %%doc}
%doc --no-dereference .rpm/licenses/*
%doc .rpm/docs/*
%{_webassetdir}/%{name}
%{_datadir}/%{name}
%exclude %{_webassetdir}/%{name}/samples

%ghost %attr(644, root, root) %{_datadir}/%{name}.rpmmoved


%files samples
%{_webassetdir}/%{name}/samples


%changelog
