Group: System/Servers
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: A spam filter for Usenet news servers
Name: cleanfeed
Version: 20020501
Release: alt3_31
# Confirmed with upstream, website
License: Artistic 2.0
URL: http://www.bofh.it/~md/cleanfeed/
Source0: http://www.bofh.it/~md/cleanfeed/cleanfeed-20020501.tgz
Patch0: cleanfeed-20020501-redhat.patch
Patch1: cleanfeed-20020501-ro.patch
BuildArch: noarch
BuildRequires: rpm-build-perl
BuildRequires: sed
Requires(pre): shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils
Source44: import.info

%description
Cleanfeed is an automatic spam filter for Usenet news servers and
routers (INN, Cyclone, Typhoon, Breeze and NNTPRelay).  Cleanfeed
looks for duplicated messages, repeated patterns, and known spamming
sites and domains.  It can be configured to block binary posts to
non-binary newsgroups, to cancel already-rejected articles, and to
reject some spamming from local users.

Install the cleanfeed package if you need a spam filter for a Usenet
news server.

%prep
%setup -q
%patch0 -p1 -b .rh
%patch1 -p1

%build
sed '1 i #!/usr/bin/perl' cleanfeed > filter_innd.pl

%pre
getent group news >/dev/null || groupadd -r news
getent passwd news >/dev/null || \
    useradd -r -g news -d %{_sysconfdir}/news -s /sbin/nologin \
    -c "cleanfeed user" news
exit 0

%install
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/news
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/news/bin/filter
install -m 0644 cleanfeed.local.sample $RPM_BUILD_ROOT/%{_sysconfdir}/news/cleanfeed.local
install -m 0644 bad_* $RPM_BUILD_ROOT/%{_sysconfdir}/news/
install -m 0755 filter_innd.pl \
	$RPM_BUILD_ROOT/%{_datadir}/news/bin/filter/filter_innd.pl

%files
%doc --no-dereference LICENSE
%doc CHANGES README HACKING TODO
%attr(-,news,news) %config(noreplace)  %{_sysconfdir}/news/cleanfeed.local
%attr(-,news,news) %config(noreplace)  %{_sysconfdir}/news/bad_*
%attr(755,news,news) %dir %{_datadir}/news/bin/filter
%attr(-,news,news) %{_datadir}/news/bin/filter/filter_innd.pl

%changelog
