# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           clipgrab
Version:        3.9.10
Release:        alt1_1
Summary:        Download and Convert online videos
License:        GPLv3+
Group:          Video
Url:            https://clipgrab.org/
Source0:        https://download.clipgrab.org/%{name}-%{version}.tar.gz
#Patch0:         https://gitlab.com/kikadf/clipgrab-qt5/raw/master/clipgrab-3.8.14-close2tray.patch
Patch1:         clipgrab-3.9.7-use-system-youtube_dlp.patch
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5WebEngine)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5Xml)
BuildRequires:  ImageMagick-tools libImageMagick7.10
Requires:       ffmpeg ffplay ffprobe
Requires:       libqt5-pdf libqt5-webengine qt5-webengine-common
Requires:       python3-module-yt_dlp yt-dlp
Source44: import.info

%description
ClipGrab is a GPLv3 licenced, free and cost-free software for downloading
and converting online videos.

%prep
%setup -q
%patch1 -p1


%build
%qmake_qt5 clipgrab.pro
%make_build

%install
mkdir -p %{buildroot}{%{_liconsdir},%{_niconsdir},%{_miconsdir}}
mkdir -p %{buildroot}%{_iconsdir}/hicolor/16x16/apps
mkdir -p %{buildroot}%{_iconsdir}/hicolor/32x32/apps
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_datadir}/applications

install -D -m755 %{name} %{buildroot}%{_bindir}
install -D -m644 *.qm %{buildroot}%{_datadir}/%{name}/
install -D -m644 *.png %{buildroot}%{_datadir}/%{name}/
install -D -m644 icon.png %{buildroot}%_niconsdir/%{name}.png

convert -geometry 32x32 icon.png %{buildroot}%{_liconsdir}/%{name}.png
convert -geometry 16x16 icon.png %{buildroot}%{_miconsdir}/%{name}.png
convert -scale 16x16 icon.png %{buildroot}%{_iconsdir}/hicolor/16x16/apps/%{name}.png
convert -scale 32x32 icon.png %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png

# Add translation lang tags
(cd %{buildroot} && find . -name '*.qm') | sed -e 's|^.||' | sed -e \
    's:\(%{_datadir}/%{name}/%{name}_\)\([a-z_A-Z]\+\)\(.*qm$\):%lang(\2) \1\2\3:'\
        >> %{name}.lang

#------------------------------------------------------------------------
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
GenericName=ClipGrab
Name=ClipGrab
Comment=Use ClipGrab to download and convert online videos
Comment[ca]=Empreu ClipGrab per descarregar i convertir vídeos online.
Comment[cs]=Použijte program ClipGrap pro stažení a konverzi online videí
Comment[de]=Benutzen Sie ClipGrab, um Online-Videos herunterzuladen und zu konvertieren.
Comment[el]=Λήψη και μετατροπή βίντεο από το διαδίκτυο
Comment[es]=Utilice ClipGrab para descargar y convertir videos de la red
Comment[et]=ClipGrab aitab videoid veebist alla laadida ja teisendada.
Comment[fr]=Utilisez ClipGrad pour télécharger et convertir des vidéos d'Internet
Comment[it]=Utilizzare ClipGrab per scaricare e convertire i video
Comment[nl]=Gebruik ClipGrab om online videos te downloaden en converteren
Comment[pl]=Użyj programu ClipGrab do pobrania i konwersji filmów online
Comment[sl]=Uporabite ClipGrab za prenos in pretvorbo spletnih videov
Comment[uk]=Скористатися ClipGrab для отримання та перетворення інтернет-відео
Comment[zh_TW]=使用 ClipGrab 來下載並轉換線上影片
Exec=clipgrab
Icon=clipgrab
Type=Application
StartupNotify=true
Categories=AudioVideo;Recorder;X-Mageia-CrossDesktop;
EOF
#------------------------------------------------------------------------

%files -f %{name}.lang
%doc README
%{_bindir}/%{name}
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*.png
%{_datadir}/applications/%{name}.desktop
%_niconsdir/%{name}.png
%{_miconsdir}/%{name}.png
%{_liconsdir}/%{name}.png
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
