# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot /usr/bin/doxygen gcc-c++
# END SourceDeps(oneline)
Summary:	A C++ port of Lucene
Name:		clucene09
Version:	0.9.21b
Release:	alt1_2
License:	LGPLv2+ or ASL 2.0
Group:		System/Libraries
URL:		http://www.sourceforge.net/projects/clucene/
Source0:	http://downloads.sourceforge.net/clucene/clucene-core-%{version}.tar.bz2
Source44: import.info

%description
CLucene is a C++ port of Lucene. It is a high-performance, full-
featured text search engine written in C++. CLucene is faster than
lucene as it is written in C++.

This package contains an old and deprecated version of clucene. You
need it only if the software you are using has not been updated to
work with the newer version and the newer API.

%package core
Summary:	Core clucene module
Group:		System/Libraries
Provides:	%{name} = %{version}-%{release}
Provides:	%{name}%{?_isa} = %{version}-%{release}

%description core
The core clucene module.

This package contains an old and deprecated version of clucene-core.
You need it only if the software you are using has not been updated
to work with the newer version and the newer API.

%package core-devel
Summary:	Development files for clucene-core
Group:		Development/C
Requires:	%{name}-core%{?_isa} = %{version}-%{release}

%description core-devel
The clucene-core-devel package includes header files and libraries
necessary for developing programs which use clucene-core library. 

This package contains an old and deprecated version of clucene-core.
You need it only if the software you are using has not been updated
to work with the newer version and the newer API.

%prep
%setup -q -n clucene-core-%{version}

%build
%configure --disable-static
make %{?_smp_mflags}

%install
make DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p' install

# Perform the necessary renaming according to package renaming
mkdir -p $RPM_BUILD_ROOT{%{_includedir},%{_libdir}}/%{name}/
mv -f $RPM_BUILD_ROOT%{_includedir}/{CLucene,CLucene.h,%{name}}
mv -f $RPM_BUILD_ROOT%{_libdir}/{CLucene,%{name}}
rm -f $RPM_BUILD_ROOT%{_libdir}/libclucene.so
ln -sf ../libclucene.so.0.0.0 $RPM_BUILD_ROOT%{_libdir}/%{name}/libclucene.so

# Don't install any libtool .la files
rm -rf $RPM_BUILD_ROOT%{_libdir}/*.la

# Fix incorrect end-of-line encoding
sed -e 's/\r//' LGPL.license > LGPL.license.eol
touch -c -r LGPL.license LGPL.license.eol
mv -f LGPL.license.eol LGPL.license

# Convert everything to UTF-8
iconv -f iso-8859-1 -t utf-8 -o README.utf8 README
touch -c -r README README.utf8
mv -f README.utf8 README

%ifnarch ppc64 s390x sparc64
%check
make check
%endif

%files core
%doc AUTHORS COPYING HACKING README REQUESTS APACHE.license LGPL.license
%doc doc/*.htm doc/*.jpg
%{_libdir}/libclucene.so.*

%files core-devel
# clucene-config.h is arch/platform specific, see RHBZ #381481
%{_libdir}/%{name}/
%{_includedir}/%{name}/

%changelog
