# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libglibmm-devel
# END SourceDeps(oneline)
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name clutter-gtkmm
%define version 0.91.8
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Summary:	A basic gtkmm Clutter widget
Name:		clutter-gtkmm
Version:	0.91.8
Release:	alt1_10
License:	LGPLv2+
Group:		System/Libraries
URL:		http://www.gtkmm.org/
Source0:	http://download.gnome.org/sources/clutter-gtkmm/0.91/%{name}-%{version}.tar.bz2

BuildRequires:	libclutter-gtk3-devel >= 0.10.2
BuildRequires:	mm-common >= 0.9.5
BuildRequires:	cluttermm-devel >= 0.9.6
BuildRequires:	doxygen
BuildRequires:	graphviz
BuildRequires:	libgtkmm3-devel
Source44: import.info

%description
Clutter-gtkmm allows Clutter to be embedded in gtkmm applications. Clutter is
a software library for creating fast, visually rich graphical user
interfaces.

%package devel
Summary:	Development files for %{name}
Group:		Development/C

Requires:	%{name}%{?_isa} = %{version}-%{release}
Requires:	devhelp

%description devel
This package contains development files for %{name}.

%prep
%setup -q

sed --in-place \
  --expression 's|clutter-gtk-0.10 |clutter-gtk-1.0 |g' \
  ./configure

sed -i 's|gtkmm-2.4|gtkmm-3.0|g' ./configure

%build
%configure --disable-silent-rules

# Omit unused direct shared library dependencies.
sed --in-place --expression 's! -shared ! -Wl,--as-needed\0!g' libtool

make %{?_smp_mflags}

%install
make install INSTALL="%{__install} -p" DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name "*.la" -delete

# adding to installed docs in order to avoid using %%doc magic
mkdir -p ${RPM_BUILD_ROOT}%{_pkgdocdir}
for f in ChangeLog COPYING NEWS ; do
    cp -p $f ${RPM_BUILD_ROOT}%{_pkgdocdir}
done
cp -p examples/redhand.png ${RPM_BUILD_ROOT}%{_pkgdocdir}
cp -a examples/events ${RPM_BUILD_ROOT}%{_pkgdocdir}

# move installed 'reference' to package-specific docdir,
# but add a softlink from /usr/share/doc/clutter-gtkmm-1.0/reference
mv $RPM_BUILD_ROOT%{_docdir}/%{name}-1.0/reference ${RPM_BUILD_ROOT}%{_pkgdocdir}
pushd $RPM_BUILD_ROOT%{_docdir}/%{name}-1.0
  ln -s $(find .. -name reference) reference
popd

%files
# deliberately no %%doc usage here
%dir %{_pkgdocdir}
%{_pkgdocdir}/ChangeLog
%{_pkgdocdir}/COPYING
%{_pkgdocdir}/NEWS
%{_libdir}/libclutter-gtkmm-1.0.so.*

%files devel
%{_pkgdocdir}/reference/
%{_pkgdocdir}/redhand.png
%{_pkgdocdir}/events/
%{_libdir}/libclutter-gtkmm-1.0.so
%{_libdir}/pkgconfig/%{name}-1.0.pc
%{_libdir}/%{name}-1.0
%{_datadir}/devhelp/books/%{name}-1.0
%{_includedir}/%{name}-1.0

%dir %{_docdir}/%{name}-1.0
%{_docdir}/%{name}-1.0/reference

%changelog
