# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libqt4-devel perl(Config.pm) perl(IO/File.pm) perl(Sys/Hostname.pm) python-devel zlib-devel
# END SourceDeps(oneline)
Name:           code-editor
Version:        2.3.1
Release:        alt1_16
Summary:        Lightweight and cross-platform text and code editor based on Qt Creator

Group:          Development/Tools
License:        LGPLv2
URL:            http://qt.gitorious.org/~ilyesgouta/qt-creator/code-editor
Source0:        code-editor-src.tar.bz2

Source1:        code-editor.desktop

Requires:       icon-theme-hicolor
Requires:       xdg-utils

BuildRequires:  desktop-file-utils

BuildRequires: qt4-devel >= 4.7

# see https://bugzilla.redhat.com/show_bug.cgi?id=652971
%{echo 

%filter_from_requires /\(libAggregation\|libCPlusPlus\|libExtensionSystem\|libLanguageUtils\|libQtConcurrent\|libUtils\)\.so.*/d
%filter_from_requires /\(libBinEditor\|libCore\|libCppEditor\|libCppTools\|libFakeVim\|libFind\|libLocator\|libTextEditor\)\.so.*/d

}
Source44: import.info
%add_findprov_skiplist %_libdir/code-editor/*

%description
CodeEditor is a slimmed down, customized version of Qt Creator that focuses on bringing
its text/code modern editing capabilities to users looking for just a simple and beautiful editor.

%prep
%setup -q -n %{name}

%build
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ; \
CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ; \
FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ; \

qmake-qt4 -makefile code-editor.pro IDE_LIBRARY_BASENAME=%{_lib}
make %{?_smp_mflags}

%install
make install INSTALL_ROOT=%{buildroot}%{_prefix}

desktop-file-install                                    \
--add-category="Development"                            \
--dir=%{buildroot}%{_datadir}/applications              \
%{SOURCE1}

rm -rf %{buildroot}%{_datadir}/code-editor/translations
rm -rf %{buildroot}%{_datadir}/code-editor/templates
rm -rf %{buildroot}%{_datadir}/code-editor/snippets
rm -rf %{buildroot}%{_datadir}/code-editor/rss
rm -rf %{buildroot}%{_datadir}/code-editor/qmlicons
rm -rf %{buildroot}%{_datadir}/code-editor/qmldesigner
rm -rf %{buildroot}%{_datadir}/code-editor/qml
rm -rf %{buildroot}%{_datadir}/code-editor/gdbmacros
rm -rf %{buildroot}%{_datadir}/code-editor/designer
rm -rf %{buildroot}%{_datadir}/code-editor/qml-type-descriptions
rm -rf %{buildroot}%{_datadir}/doc
rm -f %{buildroot}%{_bindir}/qtcreator_process_stub
rm -f %{buildroot}%{_bindir}/qtpromaker

%files
%doc README LICENSE.LGPL LGPL_EXCEPTION.TXT
%{_bindir}/code-editor
%{_libdir}/code-editor/
%{_datadir}/code-editor/
%{_datadir}/icons/hicolor/*/*/codeeditor.*
%{_datadir}/applications/code-editor.desktop

%changelog
