# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(B.pm) perl(CGI.pm) perl(CGI/Application.pm) perl(CGI/Carp.pm) perl(Config.pm) perl(DBI.pm) perl(DBIx/Abstract.pm) perl(Data/FormValidator.pm) perl(Exporter.pm) perl(File/Basename.pm) perl(HTML/FillInForm.pm) perl(HTML/Template.pm) perl(HTTP/Headers/UserAgent.pm) perl(IO/Socket.pm) perl(Image/Size.pm) perl(POSIX.pm) perl(XML/Parser.pm) perl(base.pm) perl(the.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	major		0
%define libname		libcolorer%{major}
%define develname	libcolorer-devel

Summary:	Syntax highlighting and text parsing library
Name:		colorer-take5
Version:	0
Release:	alt1_0.beta513
Group:		Text tools
License:	MPLv1.1 or GPLv2 or LGPLv2.1
URL:		http://colorer.sourceforge.net/
Source0:	http://prdownloads.sourceforge.net/colorer/Colorer-take5-linux.be5.tar.bz2
Patch0:		colorer-optflags.diff
Patch1:		colorer-soname.diff
Patch2:		colorer-DESTDIR.diff
Patch3:		colorer-take5-fix-missing-include.patch
BuildRequires:	libstdc++-devel
Requires:	%{libname} = %{version}
Source44: import.info

%description
Colorer take5 is a syntax highlighting and text parsing library, that provides
services of text parsing in host editor systems in real-time and transforming
results into colored text. Result information allows to search and build
outlined lists of functions, structures, and to search and indent programming
language constructions (brackets, paired tags). Colorer uses pure C++, XML, it
is fully portable and works on either win32/unix/mac platforms. Top level Java
language API is also available. 


%package -n	%{libname}
Summary:	Syntax highlighting and text parsing library
Group:          System/Libraries

%description -n	%{libname}
Colorer take5 is a syntax highlighting and text parsing library, that provides
services of text parsing in host editor systems in real-time and transforming
results into colored text. Result information allows to search and build
outlined lists of functions, structures, and to search and indent programming
language constructions (brackets, paired tags). Colorer uses pure C++, XML, it
is fully portable and works on either win32/unix/mac platforms. Top level Java
language API is also available. 


%package -n	%{develname}
Summary:	Static library and header files for the %{name} library
Group:		Development/C++
Requires:	%{libname} = %{version}
Requires:	%{name}-base = %{version}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}
Provides:	libcolorer-devel = %{version}-%{release}

%description -n	%{develname}
Colorer take5 is a syntax highlighting and text parsing library, that provides
services of text parsing in host editor systems in real-time and transforming
results into colored text. Result information allows to search and build
outlined lists of functions, structures, and to search and indent programming
language constructions (brackets, paired tags). Colorer uses pure C++, XML, it
is fully portable and works on either win32/unix/mac platforms. Top level Java
language API is also available. 

This package contains the development files for the %{name} library.


%package	docs
Summary:	Documentation for Colorer take5
Group:		Development/C++
BuildArch: noarch

%description	docs
Colorer take5 is a syntax highlighting and text parsing library, that provides
services of text parsing in host editor systems in real-time and transforming
results into colored text. Result information allows to search and build
outlined lists of functions, structures, and to search and indent programming
language constructions (brackets, paired tags). Colorer uses pure C++, XML, it
is fully portable and works on either win32/unix/mac platforms. Top level Java
language API is also available. 

This package contains the documentation for Colorer take5.


%package	base
Summary:	Common files for Colorer take5
Group:		Text tools

%description	base
Colorer take5 is a syntax highlighting and text parsing library, that provides
services of text parsing in host editor systems in real-time and transforming
results into colored text. Result information allows to search and build
outlined lists of functions, structures, and to search and indent programming
language constructions (brackets, paired tags). Colorer uses pure C++, XML, it
is fully portable and works on either win32/unix/mac platforms. Top level Java
language API is also available. 

This package contains common files for Colorer take5.


%prep
%setup -q -c -n %{name}
%patch0 -p0
%patch1 -p0
%patch2 -p0
%patch3 -p0

# strip away annoying ^M
find . -type f|xargs file|grep 'CRLF'|cut -d: -f1|xargs perl -p -i -e 's/\r//'
find . -type f|xargs file|grep 'text'|cut -d: -f1|xargs perl -p -i -e 's/\r//'

%build
%configure
%make_build RPM_OPT_FLAGS="%{optflags} -fpermissive -Wall -fPIC"

%install
%makeinstall_std

ln -snf libcolorer.so.%{major} %{buildroot}%{_libdir}/libcolorer.so

rm -f %{buildroot}%{_datadir}/colorer/{LICENSE,README}

rm -rf installed_docs
mv %{buildroot}%{_datadir}/doc/colorer-take5 installed_docs

%files
%{_bindir}/colorer

%files -n %{libname}
%doc LICENSE README
%{_libdir}/libcolorer.so.%{major}

%files -n %{develname}
%{_includedir}/colorer
%{_libdir}/libcolorer.so
%{_datadir}/colorer/bin

%files docs
%doc installed_docs/*

%files base
%dir %{_datadir}/colorer
%{_datadir}/colorer/catalog.xml
%{_datadir}/colorer/hrc
%{_datadir}/colorer/hrd


%changelog
