Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/appstream-util
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:   Tools for the Hughski Colorimeter
Name:      colorhug-client
Version:   0.2.8
Release:   alt1_12
License:   GPLv2+
URL:       http://www.hughski.com/
Source0:   http://people.freedesktop.org/~hughsient/releases/%{name}-%{version}.tar.xz

BuildRequires: gettext gettext-tools
BuildRequires: glib2-devel libgio libgio-devel
BuildRequires: gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires: intltool
BuildRequires: libgusb-devel libgusb-gir-devel
BuildRequires: libcolord-devel libcolord-gir-devel
BuildRequires: libcolord-gtk-devel libcolord-gtk-gir-devel
BuildRequires: libsoup-devel libsoup-gir-devel libsoup-gnome-devel libsoup-gnome-gir-devel
BuildRequires: libtool
BuildRequires: docbook-utils
BuildRequires: libcanberra-devel libcanberra-gtk-common-devel libcanberra-gtk2-devel libcanberra-gtk3-devel
BuildRequires: gobject-introspection-devel
BuildRequires: gnome-doc-utils
BuildRequires: yelp-tools
BuildRequires: itstool
BuildRequires: bash-completion

# require all the subpackages to deal with upgrades
Requires: colorhug-client-ccmx = %{version}-%{release}
Requires: colorhug-client-flash = %{version}-%{release}
Requires: colorhug-client-refresh = %{version}-%{release}
Source44: import.info

%description
The Hughski ColorHug colorimeter is a low cost open-source hardware
sensor used to calibrate screens.

This package includes the client tools which allows the user to upgrade
the firmware on the sensor or to access the sensor from command line
scripts.

%package backlight
Group: Other
Summary: ColorHug Backlight Utility
Requires: colorhug-client-common = %{version}-%{release}

%description backlight
Sample the ambient light level to control the backlight.

%package ccmx
Group: Other
Summary: ColorHug CCMX Utility
Requires: yelp
Requires: colorhug-client-common = %{version}-%{release}

%description ccmx
GUI for adding and changing CCMX calibration matrices.

%package flash
Group: Other
Summary: ColorHug Firmare Flash Utility
Requires: yelp
Requires: colorhug-client-common = %{version}-%{release}

%description flash
GUI for updating the device firmware.

%package refresh
Group: Other
Summary: ColorHug Display Analysis Utility
Requires: yelp
Requires: colorhug-client-common = %{version}-%{release}

%description refresh
GUI for analyzing a display.

%package common
Group: Other
Summary: ColorHug Client Common files

%description common
Common files used in the other subpackages.

%prep
%setup -q

%build
%configure --disable-static

%make_build V=1

%install
make install DESTDIR=$RPM_BUILD_ROOT

find %{buildroot} -type f -name "*.la" -delete

%find_lang %{name}

%files
%doc COPYING

%files backlight
%doc COPYING
%{_bindir}/colorhug-backlight
%{_datadir}/appdata/com.hughski.ColorHug.Backlight.appdata.xml
%{_datadir}/applications/com.hughski.ColorHug.Backlight.desktop
%{_datadir}/icons/hicolor/*/apps/colorhug-backlight.png
%{_mandir}/man1/colorhug-backlight.1*

%files ccmx
%doc COPYING
%{_bindir}/colorhug-ccmx
%{_datadir}/appdata/com.hughski.ColorHug.CcmxLoader.appdata.xml
%{_datadir}/applications/com.hughski.ColorHug.CcmxLoader.desktop
%{_datadir}/icons/hicolor/*/mimetypes/application-x-ccmx.*
%{_datadir}/icons/hicolor/*/apps/colorhug-ccmx.png
%{_mandir}/man1/colorhug-ccmx.1*

%files flash
%doc COPYING
%{_bindir}/colorhug-flash
%{_datadir}/appdata/com.hughski.ColorHug.FlashLoader.appdata.xml
%{_datadir}/applications/com.hughski.ColorHug.FlashLoader.desktop
%{_datadir}/icons/hicolor/*/apps/colorhug-flash.png
%{_mandir}/man1/colorhug-flash.1*

%files refresh
%doc COPYING
%{_bindir}/colorhug-refresh
%{_datadir}/appdata/com.hughski.ColorHug.DisplayAnalysis.appdata.xml
%{_datadir}/applications/com.hughski.ColorHug.DisplayAnalysis.desktop
%{_datadir}/icons/hicolor/*/apps/colorhug-refresh.png
%{_mandir}/man1/colorhug-refresh.1*

%files common -f %{name}.lang
%doc README AUTHORS NEWS COPYING
%{_bindir}/colorhug-cmd
%{_datadir}/applications/colorhug-docs.desktop
%{_datadir}/colorhug-client
%{_datadir}/glib-2.0/schemas/com.hughski.colorhug-client.gschema.xml
%{_datadir}/help/*/colorhug-client
%{_datadir}/icons/hicolor/*/apps/colorhug.*
%{_datadir}/icons/hicolor/*/apps/colorimeter-colorhug-inactive.png
%dir %{_datadir}/colorhug-client
%{_libexecdir}/colorhug*
%{_mandir}/man1/colorhug-cmd.1*
%{_datadir}/bash-completion/completions/colorhug-cmd

%changelog
