# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/ccache /usr/bin/git boost-devel gcc-c++ libGL-devel libGLU-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define uname   CGenius

Name:           commandergenius
Version:        3.5.0
Release:        alt1_1
Summary:        An open clone of the Commander Keen engines
License:        GPLv3+
Group:          Games/Arcade
Url:            https://clonekeenplus.sourceforge.net/
# Repo: https://gitlab.com/Dringgstein/Commander-Genius
# Source repacked to remove shareware raw game files from the tarball
# rm -rf Build/ dlls/ hqp/ icotool vfsroot/
Source0:        %{name}-%{version}.tar.xz

BuildRequires:  boost-complete
BuildRequires:  ccmake cmake ctest
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(SDL2_ttf)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
Commander Genius is an open-source software piece that interprets
the Commander Keen "Vorticons" and "Galaxy" series (Keen 1-6).

It features many new features such as four-player mode, hardware acceleration,
customizable button layout on a range of input devices, new difficulty modes,
and much more.

You need the original data files of Commander Keen or of a mod to play
Commander Genius. Place game folders in the ~/.CommanderGenius/games
directory (Keen 1 and Keen 4 are sharewares and can be found
on the Internet).

%prep
%setup -q


%build
%{mageia_cmake} -DBUILD_TARGET=LINUX \
       -DBUILD_SHARED_LIBS=OFF \
       -DGAMES_SHAREDIR=%{_gamesdatadir} \
       -DCMAKE_SKIP_RPATH=ON
%mageia_cmake_build

%install
# Bypass make install to give better names to the installed files

# Main executable
install -D -m755 %{_vpath_builddir}/src/%{uname}Exe %{buildroot}%{_gamesbindir}/%{name}

# Icon
install -D -m0644 share/cg.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/%{name}.svg

# Metainfo
install -D -m0644 share/metainfo/io.sourceforge.clonekeenplus.appdata.xml \
                  %{buildroot}%{_metainfodir}/io.sourceforge.clonekeenplus.appdata.xml

# Desktop entry
install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Commander Genius
Comment=Play Commander Keen games natively
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

%files
%doc changelog.txt COPYRIGHT README.md
%doc --no-dereference LICENSE
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/scalable/apps/%{name}.svg
%{_metainfodir}/io.sourceforge.clonekeenplus.appdata.xml


%changelog
