Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl-devel swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global libpkg libconcord

Name: concordance
Version: 1.5
Release: alt1_8
Summary: Software to program the Logitech Harmony remote control

License: GPLv3+
URL: http://www.phildev.net/concordance/
Source0: https://github.com/jaymzh/concordance/releases/download/v%{version}/%{name}-%{version}.tar.bz2

BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: libhidapi-devel
BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libcurl-devel
BuildRequires: libtool
BuildRequires: libzip-devel
Requires: %{libpkg} = %{version}-%{release}
Source44: import.info

%description
This software will allow you to program your Logitech Harmony universal
remote control.


%package -n %{libpkg}
Group: Development/Other
Summary: Library to talk to Logitech Harmony universal remote controls
Requires: udev
# For usbnet-based remotes: 900, 1000, 1100
Requires: dnsmasq

%description -n %{libpkg}
Library to talk to Logitech Harmony universal remote controls


%package -n %{libpkg}-devel
Group: Development/Other
Summary: Development libraries for libconcord
Requires: %{libpkg} = %{version}-%{release}

%description -n %{libpkg}-devel
Development libraries for libconcord


%package -n python3-module-libconcord
Group: Development/Other
Summary: Python 3 bindings for libconcord
Requires: %{libpkg} = %{version}-%{release}
BuildArch: noarch

%description -n python3-module-libconcord
Python 3 bindings for libconcord


%prep
%setup -q


%build
cd %{libpkg}

%configure --disable-static --disable-mime-update
%make_build
cd -

# python bindings
cd %{libpkg}/bindings/python
%python3_build
cd -

cd %{name}
export CFLAGS="%{optflags} -I../libconcord"
export LDFLAGS="%{__global_ldflags} -L../libconcord/.libs"
%configure --enable-shared
%make_build


%install
cd %{libpkg}
make DESTDIR=%{buildroot} install
make DESTDIR=%{buildroot} install_udev

find %{buildroot} -type f -name \*.a -exec rm -f {} \;
find %{buildroot} -type f -name \*.la -exec rm  -f {} \;
cd -

# python bindings
cd %{libpkg}/bindings/python
%python3_install
cd -

cd %{name}
make DESTDIR=%{buildroot} install


%files
%doc Changelog CodingStyle LICENSE SubmittingPatches TODO 
%doc README.md %{name}/INSTALL.linux
%attr(0755, root, root) %{_bindir}/*
%{_mandir}/man1/*

%files -n %{libpkg}
%doc Changelog CodingStyle LICENSE SubmittingPatches
%doc %{libpkg}/README %{libpkg}/INSTALL.linux
/lib/udev/rules.d/*.rules
/lib/udev/*.sh
%{_datadir}/mime/packages/%{libpkg}.xml
%{_libdir}/*.so.*

%files -n %{libpkg}-devel
%doc TODO
%{_includedir}/*.h
%{_libdir}/*.so

%files -n python3-module-libconcord
%doc %{libpkg}/bindings/python/README
%{python3_sitelibdir_noarch}/*


%changelog
