Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:               conman
Version:            0.3.0
Release:            alt1_6
Summary:            ConMan - The Console Manager

License:            GPLv3+
URL:                https://dun.github.io/conman/
Source0:            https://github.com/dun/%{name}/archive/%{name}-%{version}.tar.gz#/%{name}-%{version}.tar.gz

Requires:           logrotate
BuildRequires:      gcc
BuildRequires:      rpm-build-perl
BuildRequires:      libfreeipmi-devel
BuildRequires:      libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-portable systemd-services systemd-sysvinit systemd-utils
Source44: import.info

%description
ConMan is a serial console management program designed to support a large
number of console devices and simultaneous users.  It currently supports
local serial devices and remote terminal servers (via the telnet protocol).
Its features include:

  - mapping symbolic names to console devices
  - logging all output from a console device to file
  - supporting monitor (R/O), interactive (R/W), and
    broadcast (W/O) modes of console access
  - allowing clients to join or steal console "write" privileges
  - executing Expect scripts across multiple consoles in parallel


%prep
%setup -qn %{name}-%{name}-%{version}

# fix paths
sed -i -e 's|lib\/|share\/|g' lib/examples/*.exp

# fix shebang
sed -i -e 's|\/usr\/bin\/env perl|\/usr\/bin\/perl|g' conmen


%build
%configure
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT

# clean sysvinit stuff
rm -r $RPM_BUILD_ROOT/etc/{init.d,sysconfig}

# make log directories
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}.old

# examples don't belong in libdir
rm -r $RPM_BUILD_ROOT/usr/lib/%{name}/examples
# move scripts to proper place
mv $RPM_BUILD_ROOT/usr/lib/%{name} $RPM_BUILD_ROOT%{_datadir}/%{name}
chmod -x $RPM_BUILD_ROOT%{_datadir}/%{name}/*.exp
# move unit
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
install -m644 etc/%{name}.service $RPM_BUILD_ROOT/%{_unitdir}/%{name}.service

%post
%post_service conman

%preun
%preun_service conman

%files
%doc --no-dereference COPYING
%doc AUTHORS FAQ NEWS
%doc lib/examples
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%{_unitdir}/%{name}.service
%dir %{_localstatedir}/log/%{name}
%dir %{_localstatedir}/log/%{name}.old
%{_bindir}/*
%{_sbindir}/*
%{_datadir}/%{name}/
%{_mandir}/*/*


%changelog
