Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           connect-proxy
Version:        1.100
Release:        alt2_31
Summary:        SSH Proxy command helper

License:        GPLv2+
URL:            http://www.taiyo.co.jp/~gotoh/ssh/connect.html
Source0:        connect-%{version}.c
# Real source listed below, it was renamed for sanity's sake
#Source0:        http://www.taiyo.co.jp/~gotoh/ssh/connect.c
Source1:        http://www.taiyo.co.jp/~gotoh/ssh/connect.html
Patch0:         connect-proxy-make-man.patch

Requires:       openssh

BuildRequires:  gcc
Source44: import.info
%description
connect-proxy is the simple relaying command to make network connection via
SOCKS and https proxy. It is mainly intended to be used as proxy command
of OpenSSH. You can make SSH session beyond the firewall with this command.

Features of connect-proxy are:

    * Supports SOCKS (version 4/4a/5) and https CONNECT method.
    * Supports NO-AUTH and USERPASS authentication of SOCKS
    * Partially supports telnet proxy (experimental).
    * You can input password from tty, ssh-askpass or environment variable.
    * Simple and general program independent from OpenSSH.
    * You can also relay local socket stream instead of standard I/O.

%prep
#setup -q -T -c -n %{name}-%{version}
%setup -q -T -c
cp %{SOURCE0} connect.c
cp %{SOURCE1} .
%patch0 -p1

%build
make CFLAGS="$RPM_OPT_FLAGS" %{?_smp_mflags}

%install
mkdir -p $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
cp -p %{name}.1 $RPM_BUILD_ROOT%{_mandir}/man1/

%files
%doc connect.html
%{_mandir}/man1/*
%{_bindir}/%{name}

%changelog
