# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libnss swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2005 Red Hat, Inc.
# All rights reserved.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation version
# 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# END COPYRIGHT BLOCK

%define coolkey_module "CoolKey PKCS #11 Module"
%define nssdb %{_sysconfdir}/pki/nssdb

Name: coolkey
Version: 1.1.0
Release: alt1_5
Summary: CoolKey PKCS #11 module
License: LGPLv2
URL: http://directory.fedora.redhat.com/wiki/CoolKey
Source: coolkey-%{version}.tar.gz
Patch1: coolkey-cache-dir-move.patch
Patch2: coolkey-gcc43.patch
Patch3: coolkey-latest.patch
Patch4: coolkey-simple-bugs.patch
Patch5: coolkey-thread-fix.patch
Patch6: coolkey-cac.patch
Patch7: coolkey-cac-1.patch
Patch8: coolkey-pcsc-lite-fix.patch
Patch9: coolkey-fix-token-removal-failure.patch
Patch10: coolkey-update.patch
Patch11: coolkey-more-keys.patch
Group: System/Libraries
BuildRequires: autoconf
BuildRequires: pkgconfig(libpcsclite)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(nss)
Requires: nss-utils
Requires: pcsc-lite
Requires: pcsc-lite-ccid
Provides: CoolKey Openkey
Obsoletes: CoolKey Openkey
# 390 does not have libusb or smartCards
ExcludeArch: s390 s390x
Source44: import.info

%description
Linux Driver support for the CoolKey and CAC products.

%package devel
Summary: CoolKey Applet libraries
Group: System/Libraries

%description devel
Linux Driver support to access the CoolKey applet.


%prep
%setup -q
%patch1 -b .cache.dir.move
%patch2 -b .coolkey-gcc43
%patch3 -b .coolkey-latest
%patch4 -b .coolkey-simple-bugs
%patch5 -b .coolkey-thread-fix
%patch6 -b .cac
%patch7 -b .cac-1
%patch8 -b .reader-state-fix
%patch9 -p1 -b .fix-token-removal-failure
%patch10 -p1 -b .coolkey-update
%patch11 -p1 -b .coolkey-more-keys

%build
autoreconf -vfi
%configure --with-debug --disable-dependency-tracking --enable-pk11install
%make_build CFLAGS="$CFLAGS -g -O2 -fno-strict-aliasing $CFLAGS " CXXFLAGS="$CXXFLAGS -g -O2 -fno-strict-aliasing $CFLAGS"

%install
%makeinstall_std
ln -s pkcs11/libcoolkeypk11.so $RPM_BUILD_ROOT/%{_libdir}
mkdir -p $RPM_BUILD_ROOT/var/cache/coolkey

%post
isThere=`modutil -rawlist -dbdir %{nssdb} | grep %{coolkey_module} || echo NO`
if [ "$isThere" == "NO" ]; then
   if [ -x %{_bindir}/pk11install ]; then
      pk11install -p %{nssdb} 'name=%{coolkey_module} library=libcoolkeypk11.so' ||:
   fi
fi


%postun
if [ $1 -eq 0 ]; then
   modutil -delete %{coolkey_module} -dbdir %{nssdb} -force || :
fi


%files
%doc ChangeLog LICENSE
%{_bindir}/pk11install
%{_libdir}/libcoolkeypk11.so
%{_libdir}/pkcs11
%{_libdir}/libckyapplet.so.1
%{_libdir}/libckyapplet.so.1.0.0

%files devel
%{_libdir}/libckyapplet.so
%{_libdir}/pkgconfig/libckyapplet.pc
%{_includedir}/*.h



%changelog
