# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           cpdup
Version:        1.18
Release:        alt2_17
Summary:        Filesystem mirroring utility

%if 0%{?el5}
%endif
License:        BSD
URL:            http://apollo.backplane.com/FreeSrc/
Source0:        http://apollo.backplane.com/FreeSrc/cpdup-%{version}.tgz
Source1:        Makefile.linux
Patch0:         cpdup-c99.patch

BuildRequires:  gcc
Source44: import.info
Group: Archiving/Other

%description
The cpdup utility makes an exact mirror copy of the source in the
destination, creating and deleting files and directories as necessary.
UTimes, hardlinks, softlinks, devices, permissions, and flags are
mirrored.  By default, cpdup asks for confirmation if any file or
directory needs to be removed from the destination and does not copy
files which it believes to have already been synchronized (by
observing that the source and destination filea.'s size and mtimes
match).  cpdup does not cross mount points in either the source or the
destination.  As a safety measure, cpdup refuses to replace a
destination directory with a file.


%prep
%setup -q -n %{name}
%patch0 -p1

# we don't want this to get compiled
mv md5.c{,.off}
# make scripts non-executable for cleanliness
chmod -x scripts/*



%build
%make_build CFLAGS="${RPM_OPT_FLAGS}" -f %{SOURCE1}


%install
make install DESTDIR=$RPM_BUILD_ROOT -f %{SOURCE1}


%files
%doc BACKUPS PORTING scripts
%{_bindir}/*
%{_mandir}/man1/*



%changelog
