Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: libbsd-devel perl(Date/Parse.pm) perl(Env/Path.pm) perl(LockFile/Simple.pm) perl(Sys/CPU.pm) perl(Text/LevenshteinXS.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:    csmith
Version: 2.4.0
Release: alt1_8
Summary: Tool to generate random C programs for compiler testing

# Most of the source code is under BSD while few header files are GPLv2+ and LGPLv2+
License: BSD and GPLv2+ and LGPLv2+
URL:     http://embed.cs.utah.edu/csmith/
Source0: https://github.com/csmith-project/%{name}/archive/%{name}-%{version}.tar.gz

BuildRequires: ctest cmake
BuildRequires: gcc-c++
BuildRequires: gcc
BuildRequires: m4
BuildRequires: autoconf
BuildRequires: rpm-build-perl
Source44: import.info

%description
Csmith is a tool that can generate random C programs that 
statically and dynamically conform to the C99 standard. It is 
useful for stress-testing compilers, static analyzers, and 
other tools that process C code

%package devel
Group: Development/Other
Summary:        Header files and libraries for Csmith development
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description devel 
The %{name}-devel package contains the header files
and libraries for use with the Csmith package.

%prep
%setup -q -n %{name}-%{name}-%{version}

sed -i 's:/lib:/%{_lib}:' runtime/CMakeLists.txt

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install
find %{buildroot} -name *.a  -exec rm -f {} \;
rm -v %{buildroot}%{_bindir}/compiler_test.in
# remove custom headers
rm -v %{buildroot}%{_includedir}/{custom,stdint}_*

%files
%doc --no-dereference COPYING
%doc doc/probabilities.txt scripts/compiler_test.in
%doc AUTHORS ChangeLog README.md TODO
%{_bindir}/compiler_test.pl
%{_bindir}/csmith
%{_bindir}/launchn.pl
%{_libdir}/libcsmith.so.0*

%files devel
%{_includedir}/*
%{_libdir}/libcsmith.so

%changelog
