# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define debug_package %{nil}
%add_optflags -fcommon

Name:           cube-escape
Version:        0.9
Release:        alt1_7
Summary:        Progress over a maze etched on the surface of a cube
License:        GPLv3+
Group:          Games/Puzzles
URL:            https://code.google.com/p/cube-escape/
Source0:        http://cube-escape.googlecode.com/files/%{name}-%{version}.tar.gz
Source1:        %{name}.png
Patch0:         cube-escape-0.9-mga-system-wide-paths.patch
Patch1:         cube-escape-0.9-mga-respect-optflags.patch

BuildRequires:  pkgconfig(sdl)
BuildRequires:  pkgconfig(SDL_ttf)
BuildRequires:  pkgconfig(SDL_image)
Requires:       fonts-ttf-liberation
Source44: import.info

%description
Cube Escape is a game in which you are inside a cube made up of numerous
shells, with a maze etched on the surface of each shell. Escape the cube
by travelling through the mazes, including over cube edges, until you find
an upward exit. When you reach the red exit, you win.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
export CFLAGS="${CFLAGS:-%optflags}";
export CXXFLAGS="${CXXFLAGS:-%optflags}";

%make_build

%install
# Unbundle Liberation font and remove poor icon replaced by custom one
rm -f data/{LiberationMono-Regular.ttf,icon.png}

install -D -m 0755 %{name} %{buildroot}%{_gamesbindir}/%{name}
install -d -m 0755 %{buildroot}%{_gamesdatadir}/%{name}/
install -m 0644 data/* %{buildroot}%{_gamesdatadir}/%{name}/
install -D -m 0644 %{SOURCE1} %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Cube Escape
GenericName=3D maze
Comment=%{summary}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Game;LogicGame;
EOF

%files
%doc README COPYING
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/32x32/apps/%{name}.png


%changelog
