Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: pkgconfig(curlpp)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: curlpp
Version: 0.8.1
Release: alt1_15
Summary: A C++ wrapper for libcURL

License: MIT
URL: http://curlpp.org/
Source0:  https://github.com/jpbarrette/%{name}/archive/v%{version}/%{name}-%{version}.tar.gz

# patches for old curlpp 0.7.3, not needed for new curlpp > 0.8.1
# ARM 64
#Patch0:  curlpp-aarch64.patch
# fix FTBFS - rhbz 1106103
#Patch1:  curlpp-0.7.3-gcc49.patch

BuildRequires: boost-complete
BuildRequires: curl-devel
BuildRequires: ctest cmake
BuildRequires: gcc-c++
Source44: import.info

%description
cURLpp is a C++ wrapper for libcURL.


%package devel
Group: Development/C
Summary: Development files for %{name}
Requires: %{name} = %{version}-%{release}
Requires: boost-complete
Requires: pkgconfig

%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q


# Convert CRLF line endings to LF in the examples
for file in examples/*.cpp
do
	sed 's/\r//' $file > $file.new && \
	touch -r $file $file.new && \
	mv $file.new $file
done

# remove deps on global.h which in turn pulls in config.h
sed -i '28 d' include/curlpp/Types.hpp

# quick hack
sed -i s,@VERSION@,%version, extras/curlpp.pc.in

%build
%{fedora_v2_cmake} CMAKE_C_FLAGS="%{optflags}" .
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install

# Unwanted library files
rm -f %{buildroot}%{_libdir}/*.la
rm -f %{buildroot}%{_libdir}/*.a




%check
ctest -V %{?_smp_mflags}

%files
%doc doc/AUTHORS doc/TODO
%doc --no-dereference doc/LICENSE
%{_libdir}/libcurlpp.so.*


%files devel
%doc examples/*.cpp examples/README doc/guide.*
%{_bindir}/curlpp-config
%{_includedir}/curlpp/
%{_includedir}/utilspp/
%{_libdir}/libcurlpp.so
%{_libdir}/pkgconfig/curlpp.pc



%changelog
