# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/gtkdocize python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define lib_major  4
%define api        1.0
%define libname    libdee%{api}_%{lib_major}
%define gi_name    libdee-gir%{api}
%define libnamedev libdee-devel

Name:          dee
Version:       1.2.7
Release:       alt5_32
Summary:       Model to synchronize multiple instances over DBus
License:       LGPLv2+
Group:         System/Libraries
URL:           https://launchpad.net/dee
Source0:       https://launchpad.net/dee/1.0/%{version}/+download/dee-%{version}.tar.gz
# from fedora:
Patch0:        dee-1.2.7-gcc6-fixes.patch
Patch1:        dee-1.2.7-deprecated-g_type_class_add_private.patch
# from debian:
Patch10:       build_no_werror.patch
Patch11:       vapi-skip-properties.patch
Patch12:       icu-pkg-config.patch
Patch13:       strict-prototype.patch
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(gobject-introspection-1.0)
BuildRequires: pkgconfig(python3)
BuildRequires: vala vala-tools
BuildRequires: libvala-devel vala-tools
BuildRequires: libicu-devel
Requires:      python3-module-pygobject3
Source44: import.info

%description
Libdee is a library that uses DBus to provide objects allowing you to create
Model-View-Controller type programs across DBus. It also consists of utility
objects which extend DBus allowing for peer-to-peer discoverability of known
objects without needing a central registrar.

%package -n %{libname}
Summary:       Model to synchronize multiple instances over DBus - Shared lib
Group:         System/Libraries

%description -n %{libname}
Libdee is a library that uses DBus to provide objects allowing you to create
Model-View-Controller type programs across DBus. It also consists of utility
objects which extend DBus allowing for peer-to-peer discoverability of known
objects without needing a central registrar.

%package -n %{gi_name}
Summary:       GObject Introspection interface library for %{name}
Group:         System/Libraries
Requires:      %{libname} = %{version}-%{release}

%description -n %{gi_name}
GObject Introspection interface library for %{name}.

%package -n %{libnamedev}
Summary:       Libraries and include files for developing with libdee
Group:         Development/C
Requires:      %{libname} = %{version}
Requires:      %{gi_name} = %{version}
Provides:      %{name}-devel = %{version}-%{release}

%description -n %{libnamedev}
This package contains files that are needed to build applications.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1


%build
autoreconf -fi
%configure --disable-static PYTHON=%{__python3}
%make_build

%install
%makeinstall_std

find %{buildroot} -name '*.la' -delete

%files
%{_bindir}/dee-tool
%{python3_sitelibdir}/gi/overrides/Dee.*
%{python3_sitelibdir}/gi/overrides/__pycache__/Dee.*

%files -n %{libname}
%{_libdir}/libdee-%{api}.so.%{lib_major}
%{_libdir}/libdee-%{api}.so.%{lib_major}.*

%files -n %{gi_name}
%{_libdir}/girepository-1.0/Dee-%{api}.typelib

%files -n %{libnamedev}
%doc %{_datadir}/gtk-doc/html/dee-*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_includedir}/*
%{_datadir}/gir-1.0/*.gir
%{_datadir}/vala/vapi/*


%changelog
