# TODO: fix properly
%add_findreq_skiplist /usr/bin/denyhosts-control
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-helper rpm-macros-mageia-compat
BuildRequires: python3-devel python3-module-setuptools /usr/bin/pathfix.py
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname denyhost

Name:             denyhosts
Version:          3.1
Release:          alt1_9
Summary:          A script to help thwart ssh server attacks

Group:            Networking/Other
License:          GPLv2
URL:              http://denyhost.sourceforge.net/
Source0:          http://download.sourceforge.net/%{oname}/%{name}-%{version}.tar.gz
Source1:          denyhosts.cron
Source3:          denyhosts-allowed-hosts
Source4:          denyhosts.sysconfig
Source5:          denyhosts.logrotate
Source6:          README.fedora
Source7:          denyhosts.service
Source8:          denyhosts.tmpfiles
Patch0:           denyhosts-3.1-mga-config.patch
Patch1:           denyhosts-3.1-rundir.patch
Patch2:           0001-Fixed-the-AttributeError-related-to-issue-54.patch

BuildArch:        noarch
BuildRequires:    pkgconfig(python3)
BuildRequires:    systemd-units
BuildRequires:    python3-module-ipaddr
Requires:         openssh-server
Requires:         python3-module-ipaddr
Requires:         rsyslog
Requires(post):   rpm-helper
Requires(preun):  rpm-helper
Source44: import.info

%description
DenyHosts is a Python script that analyzes the sshd server log
messages to determine which hosts are attempting to hack into your
system. It also determines what user accounts are being targeted. It
keeps track of the frequency of attempts from each host and, upon
discovering a repeated attack host, updates the /etc/hosts.deny file
to prevent future break-in attempts from that host.  Email reports can
be sent to a system admin.


%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1
%patch2 -p1


# This must be moved before the Python build process runs so that we
# can include it as documentation.
mv plugins/README.contrib .

# And the permissions are off as well
chmod +x plugins/*

%build
%python3_build

%install
%python3_install

install -d %{buildroot}/%{_bindir}
install -d %{buildroot}/%{_sysconfdir}/cron.d
install -d %{buildroot}/%{_sysconfdir}/logrotate.d
install -d %{buildroot}/%{_sysconfdir}/sysconfig

install -d -m 700 %{buildroot}/%{_localstatedir}/lib/denyhosts
install -d %{buildroot}/%{_localstatedir}/log

install -p -m 600 denyhosts.conf %{buildroot}/%{_sysconfdir}/denyhosts.conf
install -p -m 755 daemon-control-dist %{buildroot}/%{_bindir}/denyhosts-control
install -p -m 644 %{SOURCE1} %{buildroot}/%{_sysconfdir}/cron.d/denyhosts
install -p -m 644 %{SOURCE3} %{buildroot}/%{_localstatedir}/lib/denyhosts/allowed-hosts
install -p -m 644 %{SOURCE4} %{buildroot}/%{_sysconfdir}/sysconfig/denyhosts
install -p -m 644 %{SOURCE5} %{buildroot}/%{_sysconfdir}/logrotate.d/denyhosts
install -D -m 644 %{SOURCE7} %{buildroot}%{_unitdir}/%{name}.service
install -D -m 644 %{SOURCE8} %{buildroot}%{_tmpfilesdir}/%{name}.conf
install -d %{buildroot}%{_rundir}/%{name}

# We don't want this because it serves no purpose on Mageia
rm -f %{buildroot}/%{_bindir}/daemon-control-dist

touch %{buildroot}/%{_localstatedir}/log/denyhosts

for i in allowed-warned-hosts hosts hosts-restricted hosts-root \
         hosts-valid offset suspicious-logins sync-hosts \
         users-hosts users-invalid users-valid; do
  touch %{buildroot}/%{_localstatedir}/lib/denyhosts/$i
done

# python shebangs
pathfix.py -pni "%{__python3} " %{buildroot}%{_bindir}/denyhosts-control
for rpm404_ghost in %{_logdir}/denyhosts %{_localstatedir}/lib/denyhosts/allowed-warned-hosts %{_localstatedir}/lib/denyhosts/hosts %{_localstatedir}/lib/denyhosts/hosts-restricted %{_localstatedir}/lib/denyhosts/hosts-root %{_localstatedir}/lib/denyhosts/hosts-valid %{_localstatedir}/lib/denyhosts/offset %{_localstatedir}/lib/denyhosts/suspicious-logins %{_localstatedir}/lib/denyhosts/sync-hosts %{_localstatedir}/lib/denyhosts/users-hosts %{_localstatedir}/lib/denyhosts/users-invalid %{_localstatedir}/lib/denyhosts/users-valid %{_rundir}/%{name} %{_rundir}/%{name}/denyhosts.pid
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%preun
%_preun_service %name

%post
%_tmpfilescreate %{name}
# Note that we do not automaticaly run --migrate, because we can't be
# sure that all of the hosts.deny entries were created by denyhosts
%_post_service %name

touch %{_logdir}/denyhosts
touch %{_localstatedir}/lib/denyhosts/allowed-warned-hosts
touch %{_localstatedir}/lib/denyhosts/hosts
touch %{_localstatedir}/lib/denyhosts/hosts-restricted
touch %{_localstatedir}/lib/denyhosts/hosts-root
touch %{_localstatedir}/lib/denyhosts/hosts-valid
touch %{_localstatedir}/lib/denyhosts/suspicious-logins
touch %{_localstatedir}/lib/denyhosts/sync-hosts
touch %{_localstatedir}/lib/denyhosts/users-hosts
touch %{_localstatedir}/lib/denyhosts/users-invalid
touch %{_localstatedir}/lib/denyhosts/users-valid

%postun
if [ $1 -ge 1 ] ; then
  systemctl restart %name.service >/dev/null 2>&1
fi


%files
%doc CHANGELOG.txt denyhosts.conf
%doc README*

%{_bindir}/denyhosts.py
%{_bindir}/denyhosts-control
%{python3_sitelibdir_noarch}/*
%{_mandir}/man8/%{oname}*

%config(noreplace) %{_sysconfdir}/denyhosts.conf
%config(noreplace) %{_sysconfdir}/cron.d/denyhosts
%config(noreplace) %{_sysconfdir}/logrotate.d/denyhosts
%config(noreplace) %{_sysconfdir}/sysconfig/denyhosts
%config(noreplace) %{_localstatedir}/lib/denyhosts/allowed-hosts

%ghost %{_logdir}/denyhosts
%ghost %{_localstatedir}/lib/denyhosts/allowed-warned-hosts
%ghost %{_localstatedir}/lib/denyhosts/hosts
%ghost %{_localstatedir}/lib/denyhosts/hosts-restricted
%ghost %{_localstatedir}/lib/denyhosts/hosts-root
%ghost %{_localstatedir}/lib/denyhosts/hosts-valid
%ghost %{_localstatedir}/lib/denyhosts/offset
%ghost %{_localstatedir}/lib/denyhosts/suspicious-logins
%ghost %{_localstatedir}/lib/denyhosts/sync-hosts
%ghost %{_localstatedir}/lib/denyhosts/users-hosts
%ghost %{_localstatedir}/lib/denyhosts/users-invalid
%ghost %{_localstatedir}/lib/denyhosts/users-valid

%dir %ghost %attr(0755, root, root) %{_rundir}/%{name}
%ghost %attr(0660, -, -) %{_rundir}/%{name}/denyhosts.pid

%dir %{_localstatedir}/lib/denyhosts

%{_unitdir}/%{name}.service
%{_tmpfilesdir}/%{name}.conf


%changelog
