Group: Toys
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define waddir  %{_datadir}/doom

Name:           deutex
Version:        5.2.2
Release:        alt2_11
Summary:        DOOM wad file manipulator

# All files LGPLv2+ or GPLv2+ except ./src/lzw.c which is MIT
License:        GPL-2.0-or-later and MIT
URL:            https://github.com/Doom-Utils/deutex
Source0:        https://github.com/Doom-Utils/deutex/archive/v%{version}/%{name}-%{version}.tar.gz
Patch0:         deutex-5.2.0-waddir.patch
BuildRequires:	gcc, autoconf, automake asciidoc asciidoc-a2x
BuildRequires: libpng-devel libpng17-tools
Source44: import.info

%description
DeuTex is a wad composer for Doom, Heretic, Hexen and Strife. It can be
used to extract the lumps of a wad and save them as individual files.
Conversely, it can also build a wad from separate files. When extracting
a lump to a file, it does not just copy the raw data, it converts it to
an appropriate format (such as PPM for graphics, Sun audio for samples,
etc.). Conversely, when it reads files for inclusion in pwads, it does
the necessary conversions (for example, from PPM to Doom picture
format). In addition, DeuTex has functions such as merging wads, etc. If
you're doing any wad hacking beyond level editing, DeuTex is a must.


%prep
%setup -q
%patch0 -p0


%build
autoreconf -if
%configure --with-libpng
make CFLAGS="$RPM_OPT_FLAGS -DDOOMDIR=\"\\\"%{waddir}\\\"\"" %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT

%files
%{_bindir}/deutex
%{_mandir}/man6/*
%doc --no-dereference LICENSE
%doc COPYING COPYING.LIB AUTHORS README.adoc NEWS.adoc


%changelog
