Group: Development/Tools
BuildRequires: libncurses-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		devtodo
Version:	0.1.20
Summary:	Manage a prioritised list of todo items organized by directory
Release:	alt2_36
License:	GPLv2
URL:		http://swapoff.org/DevTodo
Source0:	http://swapoff.org/files/%{name}/%{name}-%{version}.tar.gz
Patch0:		%{name}-0.1.20-buildfixes.patch
Patch1:     %{name}-aarch64.patch

BuildRequires:  gcc-c++
BuildRequires:  libtool
BuildRequires:  automake
BuildRequires:  autoconf
BuildRequires:	libreadline-devel
Source44: import.info

%description
Todo is a program to display and manage a hierarchical, prioritised list of 
outstanding work, or just reminders.

The program itself is assisted by a few shell scripts that override default
builtins. Specifically, cd, pushd and popd are overridden so that when using
one of these commands to enter a directory, the todo will display any 
outstanding items in that directory.

For much more complete information please refer to the man page (devtodo(1)).


%prep
%setup -q
%patch0 -p1 -b .bfix
%patch1 -p1

%build
export CPPFLAGS="-I%{_includedir}/readline5" LDFLAGS="-L%{_libdir}/readline5"
%configure

%make_build


%install
make DESTDIR=%{buildroot} install

mkdir -p %{buildroot}/%{_sysconfdir}/profile.d
install -p -m 644 doc/scripts.sh %{buildroot}/%{_sysconfdir}/profile.d/devtodo.sh
install -p -m 644 doc/scripts.tcsh %{buildroot}/%{_sysconfdir}/profile.d/devtodo.tcsh



%files
%config(noreplace) %{_sysconfdir}/todorc
%config(noreplace) %{_sysconfdir}/profile.d/devtodo.sh
%config(noreplace) %{_sysconfdir}/profile.d/devtodo.tcsh
%{_bindir}/devtodo
%{_bindir}/todo
%{_bindir}/tda
%{_bindir}/tdr
%{_bindir}/tde
%{_bindir}/tdd
%{_bindir}/tdl
%{_mandir}/man?/*
%doc AUTHORS README COPYING NEWS QuickStart doc/todorc.example ChangeLog


%changelog
