Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		disper
Version:	0.3.1
Release:	alt1_16
Summary:	On-the-fly display switch utility
License:	GPLv3+
URL:		http://willem.engen.nl/projects/disper/
Source0:	http://ppa.launchpad.net/disper-dev/ppa/ubuntu/pool/main/d/disper/%{name}_%{version}.tar.gz
Patch0:		disper_0.3.1-fix_Makefile.patch
Patch1:		disper_0.3.1-fix-misbehavior-bug-1531704.diff
BuildArch:	noarch
BuildRequires:	python-devel
BuildRequires:	help2man
# disper require notify-send included in libnotify package
Requires:	libnotify notify-send
# disper require libXrandr and libX11 too, the library are loaded via python and
# rpm doesn't find these dependencies by itself
Requires:	libXrandr
Requires:	libX11
Source44: import.info


%description
Disper is an on-the-fly display switch utility. It is intended to be used just
before giving a presentation with a laptop, when all one wants is that the
beamer, which has just been connected, is able to show whatever you prepared.

Disper gives you the option to either clone all detected displays, or extend
the desktop to them. Resolutions are automatically detected. For cloning, the
highest common resolution supported by all displays is chosen; for extending
every display device gets its highest supported resolution. For special setups
requiring more detailed control, one can still use the standard display
configuration utilities.

At the moment nVidia cards are supported, and a basic XRandR backend is in
place.


%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1


#fix to #!/usr/bin/env python. Change it to python3 (or python2) explicitly.
sed -i '1s/env python/python2/' src/disper.py
sed -i '1s/env python/python2/' src/xrandr/gdk.py
sed -i '1s/env python/python2/' src/xrandr/__init__.py
sed -i '1s/env python/python2/' src/xrandr/core.py
sed -i '1s/env python/python2/' disper.in


%build


%install
DESTDIR=%{buildroot} PREFIX=%{_prefix} \
  BINDIR=%{_bindir} DATADIR=%{_datadir} \
  make install
# fcami - kludge starts here
# - disper installs itself in %{_datadir}/%{name}/src ...
#   so rename that directory to %{python_sitelibdir_noarch}%{name}
mkdir -p %{buildroot}%{python_sitelibdir_noarch}
mv %{buildroot}%{_datadir}/%{name}/src %{buildroot}%{python_sitelibdir_noarch}/%{name}
# - adapt the hardcoded system path in /usr/bin/disper to %{python_sitelibdir_noarch}%{name}
sed -i "s,^sys\.path\.append.*,sys\.path\.append\(\'%{python_sitelibdir_noarch}/%{name}\'\),g" %{buildroot}%{_bindir}/%{name}
# end kludge
# these should already be +x in the sources
chmod +x %{buildroot}%{python_sitelibdir_noarch}/%{name}/xrandr/core.py
chmod +x %{buildroot}%{python_sitelibdir_noarch}/%{name}/xrandr/gdk.py
chmod +x %{buildroot}%{python_sitelibdir_noarch}/%{name}/xrandr/__init__.py
gzip %{name}.1
install -Dpm 0644 %{name}.1.gz %{buildroot}%{_mandir}/man1/%{name}.1.gz


%files
%doc README TODO
%{_bindir}/%{name}
%{python_sitelibdir_noarch}/*
%{_datadir}/%{name}
%{_datadir}/pixmaps/%{name}.svg
%{_mandir}/man1/%{name}.1*

%changelog
