%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name dmalloc
%define devname lib%{name}-devel
%define libname lib%{name}

Name:		dmalloc
Version:	5.6.5
Release:	alt1_2
Summary:	Debugging MALLOC
License:	BSD style
URL:		http://dmalloc.com/
Group:		Development/Other
Source:		http://dmalloc.com/releases/%{name}-%{version}.tgz
Requires:	%{devname} = %{version}
Source44: import.info

%package -n %{devname}
Summary:	Debugging MALLOC library
Group:		Development/Other
Provides:	dmalloc-devel = %{version}-%{release}
#Provides:	libdmalloc-devel = %{version}-%{release}
Provides:	%{libname} = %{version}-%{release}
Obsoletes:	dmalloc-devel < %{version}-%{release}
#Obsoletes:	libdmalloc-devel < %{version}-%{release}
Obsoletes:	%{libname} < %{version}-%{release}

%description
The debug memory allocation or "dmalloc" library has been designed
as a drop in replacement for the system's `malloc', `realloc',
`calloc', `free' and other memory management routines while providing
powerful debugging facilities configurable at run-time.  These
facilities include such things as memory-leak tracking, fence-post write
detection, file/line number reporting, and general logging of
statistics.

%description -n %{devname}
The debug memory allocation or "dmalloc" library has been designed
as a drop in replacement for the system's `malloc', `realloc',
`calloc', `free' and other memory management routines while providing
powerful debugging facilities configurable at run-time.  These
facilities include such things as memory-leak tracking, fence-post write
detection, file/line number reporting, and general logging of
statistics.

%prep
%setup -q
chmod -R o+rX .

%build
export CFLAGS=`echo %optflags | sed 's/-O2/-O0/'`

# testing program will segfault when building with -fPIC flag, so
# don't build shared library at all. Anyway this is for developers,
# so building static library is enough.
%configure --enable-threads

# Segfaults with 'make heavy'
make

%install
%makeinstall_std	bindir=%{buildroot}%{_bindir} \
				libdir=%{buildroot}%{_libdir} \
				includedir=%{buildroot}%{_includedir}

%files
%doc ChangeLog.txt README.md TODO %{name}.html 
%{_bindir}/*

%files -n %{devname}
%{_includedir}/*
%{_libdir}/*.a


%changelog
