Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Rcs.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
BuildRequires: perl(CGI.pm) perl(RRDs.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           drraw
Version:        2.2
Release:        alt1_0.26.b2
Summary:        Web based presentation front-end for RRDtool

License:        BSD
URL:            http://web.taranis.org/drraw/
Source0:        http://web.taranis.org/drraw/dist/drraw-2.2b2.tar.gz
Source1:        drraw-httpd.conf
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(CGI.pm)
BuildRequires:  perl(CGI/Carp.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(RRDs.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)

Requires:       apache2-mod_perl 
Source44: import.info
Patch33:  drraw-2.2b2-alt-perl534.patch


%description
drraw is a simple web based presentation front-end for RRDtool that allows you
to interactively build graphs of your own design. A graph definition can be
turned into a template which may be applied to many Round Robin Database files.
drraw specializes in providing an easy mean of displaying data stored with
RRDtool and does not care about how the data is collected, making it a great
complement to other RRDtool front-ends.


%package selinux
Group: File tools
Summary:          SELinux context for %{name}
Requires:         %name = %version-%release
Requires(post):   policycoreutils
Requires(postun): policycoreutils


%description selinux
SElinux context for drraw.


%prep
%setup -q -n drraw-2.2b2
# Set work dirs in conf file
sed -i -e "s|^\$saved_dir = .*|\$saved_dir = '/var/lib/drraw';|" \
       -e "s|^\$tmp_dir = .*|\$tmp_dir = '/var/tmp';|" drraw.conf
# Patch drraw.cgi for conf file location
sed -i -e 's|^my $config = .*|my $config = "/etc/drraw.conf";|' drraw.cgi
# Fix file encoding
iconv -f iso8859-1 -t utf-8 CHANGES > CHANGES.conv && \
touch -r CHANGES CHANGES.conv && \
mv -f CHANGES.conv CHANGES
%patch33 -p1

%build
# Nothing to build


%install
install -Dp -m 0755 drraw.cgi $RPM_BUILD_ROOT/%{_datadir}/%{name}/drraw.cgi
install -Dp -m 0644 drraw.conf $RPM_BUILD_ROOT/%{_sysconfdir}/drraw.conf
install -Dp -m 0644 %{SOURCE1} $RPM_BUILD_ROOT/%{_sysconfdir}/httpd/conf.d/drraw.conf
mkdir -p $RPM_BUILD_ROOT/%{_localstatedir}/lib/%{name}



%post selinux
semanage fcontext -a -t httpd_sys_script_exec_t '%{_datadir}/%{name}(/.*)?' 2>/dev/null || :
semanage fcontext -a -t httpd_sys_rw_content_t '%{_localstatedir}/lib/%{name}(/.*)?' 2>/dev/null || :
restorecon -R %{_datadir}/%{name} %{_localstatedir}/lib/%{name} || :


%postun selinux
if [ $1 -eq 0 ] ; then
semanage fcontext -d -t httpd_sys_script_exec_t '%{_datadir}/%{name}(/.*)?' 2>/dev/null || :
semanage fcontext -d -t httpd_sys_rw_content_t '%{_localstatedir}/lib/%{name}(/.*)?' 2>/dev/null || :
fi


%files
%doc --no-dereference LICENSE
%doc README.EVENTS INSTALL CHANGES
%config(noreplace) %{_sysconfdir}/drraw.conf
%config(noreplace) %{_sysconfdir}/httpd/conf.d/drraw.conf
%{_datadir}/%{name}
%attr(755,apache,root) %{_localstatedir}/lib/%{name}


%files selinux


%changelog
