Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		dt
Version:	21.27.git8d78d78
Release:	alt2_13
Summary:	Generic data test program
License:	MIT
URL:		https://github.com/RobinTMiller/dt
BuildRequires:  gcc, libuuid-devel
# Generated from new official github repo
# https://github.com/RobinTMiller/dt by command:
# git archive --format=tar.xz --prefix=dt.v21.27.git8d78d78/ 8d78d78 > dt-source-v21.27.git8d78d78.tar.xz
Source0: dt-source-v%{version}.tar.xz
Patch0: dt-manpage.patch
Source44: import.info

%description
dt is a generic data test program used to verify proper operation of
peripherals, file systems, device drivers, or any data stream supported by the
operating system. In its' simplest mode of operation, dt writes and then
verifies its' default data pattern, then displays performance statistics and
other test parameters before exiting. Since verification of data is performed,
dt can be thought of as a generic diagnostic tool.

dt command lines are similar to the dd program, which is popular on most UNIX
systems. It contains numerous options to give the user control of various test
parameters.

dt has been used to successfully test disks, tapes, serial lines, parallel
lines, pipes, and memory mapped files. In fact, dt can be used for any device
that allows the standard open, read, write, and close system calls. Special
support is necessary for some devices, such as serial lines, for setting up the
speed, parity, data bits, etc.

Available documentation is located in %{_defaultdocdir}/%{name}. Sample
scripts and config data are installed in %{_datadir}/%{name}.

%global __requires_exclude_from ^%{_datadir}/%{name}/.*$
%prep
%setup -q -n dt.v%{version}
%patch0 -p1

%build
mkdir tmp
cd tmp
%make_build CFLAGS="%{optflags} -I.. -DAIO -DMMAP -D__linux__ -D_GNU_SOURCE -D_FILE_OFFSET_BITS=64 -DSCSI" -f ../Makefile.linux VPATH=.. OS=linux

%install
install -d -m755 $RPM_BUILD_ROOT%{_sbindir}
install -d -m755 $RPM_BUILD_ROOT%{_mandir}/man8
install -d -m755 $RPM_BUILD_ROOT%{_datadir}/%{name}
install -d -m755 $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/html
install -m755 tmp/dt $RPM_BUILD_ROOT%{_sbindir}
install -m644 Documentation/dt.man $RPM_BUILD_ROOT%{_mandir}/man8/%{name}.8
install -m755 Scripts/dt? $RPM_BUILD_ROOT%{_datadir}/%{name}
install -m644 data/pattern_* $RPM_BUILD_ROOT%{_datadir}/%{name}
install -m644 html/* $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/html

%files
%{!?_licensedir:%global license %%doc}
%doc --no-dereference LICENSE
%doc Documentation/dt-UsersGuide.txt Documentation/ReleaseNotes-dt*.txt html
%{_sbindir}/%{name}
%{_datadir}/%{name}
%{_mandir}/man8/%{name}.**

%changelog
