Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install perl(Tk.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           dxcc
Version:        20080225
Release:        alt2_50
Summary:        Small utility which determines the ARRL DXCC entity of a ham radio callsign

License:        GPLv2+
URL:            http://fkurz.net/ham/dxcc.html
Source0:        http://fkurz.net/ham/dxcc/%{name}-%{version}.tar.gz
#add .desktop file
Source1:        %{name}.desktop
#temporary Icon
Source2:        %{name}.png
#fix install path
Patch0:         dxcc-20071205-makefile.patch
#separate core and gui
Patch1:         dxcc-20071205-gui.patch

BuildArch:      noarch
Source44: import.info


%description
dxcc is a small utility which determines the ARRL DXCC entity of a ham radio
callsign, based on the cty.dat country file by Jim Reisert, AD1C. 

Optional GUI with a world map showing the DXCC's location available.

%package gui
Group: Communications
Summary:       Optional GUI with a world map showing the DXCC's location
BuildRequires: desktop-file-utils
BuildRequires: rpm-build-perl
Requires:      %{name} = %{version}-%{release}
Requires:      perl(Tk.pm)

%description gui
dxcc-gui is a small utility which determines the ARRL DXCC entity of a amateur 
radio callsign, based on the cty.dat country file by Jim Reisert, AD1C. 

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
%make_build

%install
%makeinstall_std

# no upstream .desktop or icon yet
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/pixmaps/
cp %{SOURCE2} ${RPM_BUILD_ROOT}%{_datadir}/pixmaps/%{name}.png
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE1}

%files
%doc ChangeLog COPYING README
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_datadir}/%{name}

%files gui
%doc COPYING
%{_bindir}/%{name}-gui
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/*%{name}.desktop

%changelog
