Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname e00compr
Name:           e00compr
Version:        1.0.1
Release:        alt2_25
Summary:        Library to compress and uncompress E00 files

License:        MIT
URL:            http://avce00.maptools.org/e00compr
Source0:        http://avce00.maptools.org/dl/%{name}-%{version}.tar.gz

BuildRequires:  gcc
Source44: import.info

%description
ANSI-C library to compress and uncompress Arc/Info Export (E00) files.
The package also contains a converter binary.

%package devel
Group: Development/Other
Summary: Development files for %{name}
Provides: %{name}-static = %{version}-%{release}

%description devel
Contains %{name}'s development headers and library.


%prep
%setup -q
chmod -x *.h *.c
sed -i 's/\r$//' README.TXT

# Use actual header file locations in examples and documentation
sed -i 's|#include "e00compr.h"|#include <e00compr/e00compr.h>|' ex_*.c %{name}.txt %{name}.html


%build
%make_build CFLAGS="%{optflags} -fPIC"


%install
mkdir -p %{buildroot}%{_includedir}/%{name}
mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_libdir}
mkdir -p %{buildroot}%{_bindir}

# Header name conflict with cpl (cpl_error.h)
# http://bugzilla.maptools.org/show_bug.cgi?id=2367
install -pm 0644 *.h %{buildroot}%{_includedir}/%{name}
install -pm 0644 *.1 %{buildroot}%{_mandir}/man1
install -pm 0644 *.a %{buildroot}%{_libdir}
install -pm 0755 e00conv %{buildroot}%{_bindir}


%files
%doc HISTORY.TXT README.TXT e00compr.html
%{_bindir}/e00conv
%{_mandir}/man1/e00conv.1*

%files devel
%doc ex_*.c README.TXT
%{_includedir}/%{name}/*.h
%{_libdir}/*.a


%changelog
