# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		e2guardian-children-blacklists
Version:	20230217
Release:	alt1_1
Summary:	Children Blacklists for e2guardian
#CC-BY-SA for blacklists, GPLv3+ for other
License:	CC-BY-SA and GPLv3+
Group:		System/Servers
URL:		https://dsi.ut-capitole.fr/blacklists
Source0:	https://dsi.ut-capitole.fr/blacklists/download/blacklists.tar.gz
Source1:	children-blacklists.txt
Source2:	update-e2guardian-blacklists
BuildArch:	noarch
AutoReqProv:	no

Requires:	e2guardian
Requires:	wget
Source44: import.info

%description
Blacklists for e2guardian, which were configured for Children.
If you want to add new content in blacklists please go:
https://dsi.ut-capitole.fr/cgi-bin/squidguard_modify.cgi
and wait an updates with running update-e2guardian-blacklists.

%prep
%setup -q -n blacklists

#Remove symlinks and pdf
rm -f ads
rm -f aggressive
rm -f drugs
rm -f mail
rm -f porn
rm -f proxy
rm -f violence
rm -f squidguard*
rm -f *.pdf

%build
#nothing

%install
mkdir -p %{buildroot}%{_sysconfdir}/e2guardian/lists/blacklists
cp -Rf ./* %{buildroot}%{_sysconfdir}/e2guardian/lists/blacklists/
cp -f %{SOURCE1} %{buildroot}%{_sysconfdir}/e2guardian/lists/blacklists/
install -Dpm 755 %{SOURCE2} %{buildroot}%{_bindir}/update-e2guardian-blacklists

%post
cat %{_sysconfdir}/e2guardian/lists/blacklists/children-blacklists.txt | grep -v "#" | while read LINE
do
  A=`cat %{_sysconfdir}/e2guardian/lists/bannedsitelist|grep "^.Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/domains"`
  if [ "$A" = "" ]
  then
    if [ -f "%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/domains" ]
    then
      echo ".Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/domains>" >> %{_sysconfdir}/e2guardian/lists/bannedsitelist
    fi
  fi
done
cat %{_sysconfdir}/e2guardian/lists/blacklists/children-blacklists.txt | grep "#"|cut -d "#" --fields=2 | while read LINE
do
  if [ -f "%{_sysconfdir}/e2guardian/lists/bannedsitelist" ]
  then
    sed -i "s|.Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/domains>||g" %{_sysconfdir}/e2guardian/lists/bannedsitelist
  fi
done

#bannedurllist
cat %{_sysconfdir}/e2guardian/lists/blacklists/children-blacklists.txt | grep -v "#" | while read LINE
do
  A=`cat %{_sysconfdir}/e2guardian/lists/bannedurllist|grep "^.Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/urls>"`
  if [ "$A" = "" ]
  then
    if [ -f "%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/urls" ]
    then
      echo ".Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/urls>" >> %{_sysconfdir}/e2guardian/lists/bannedurllist
    fi
  fi
done
cat %{_sysconfdir}/e2guardian/lists/blacklists/children-blacklists.txt | grep "#"|cut -d "#" --fields=2 | while read LINE
do
  if [ -f "%{_sysconfdir}/e2guardian/lists/bannedurllist" ]
  then
    sed -i "s|.Include<%{_sysconfdir}/e2guardian/lists/blacklists/$LINE/urls>||g" %{_sysconfdir}/e2guardian/lists/bannedurllist
  fi
done

%postun
if [ $1 = 0 ]; then
  for file in `cat %{_sysconfdir}/e2guardian/lists/bannedsitelist|grep "^.Include"|cut -d "<" --fields=2|cut -d ">" --fields=1`
  do
    if [ ! -f "$file" ]
    then
      sed -i -e "s|^.Include<$file>||g" %{_sysconfdir}/e2guardian/lists/bannedsitelist
      sed -i -e' /./,/^$/!d' %{_sysconfdir}/e2guardian/lists/bannedsitelist
    fi
  done
  for file in `cat %{_sysconfdir}/e2guardian/lists/bannedurllist|grep "^.Include"|cut -d "<" --fields=2|cut -d ">" --fields=1`
  do
    if [ ! -f "$file" ]
    then
      sed -i -e "s|^.Include<$file>||g" %{_sysconfdir}/e2guardian/lists/bannedurllist
      sed -i -e' /./,/^$/!d' %{_sysconfdir}/e2guardian/lists/bannedurllist
    fi
  done
fi

%files
%config %{_sysconfdir}/e2guardian/lists/blacklists
%{_bindir}/update-e2guardian-blacklists


%changelog
