Group: Graphics
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           earth-and-moon-backgrounds
Version:        0.2
Release:        alt1_15
Summary:        Earth-and-moon desktop backgrounds

License:        CC-BY-SA
URL:            http://bioinformatiques.free.fr/

Source0:        %{name}-%{version}.tar.xz

BuildArch:      noarch
Requires:       %{name}-common = %{version}-%{release}
Requires:       %{name}-dual = %{version}-%{release}
Source44: import.info

%description
This package contains desktop backgrounds for the earth-and-moon theme.

%prep
%setup -q

%package        common
Group: Graphics
Summary:        Earth-and-moon desktop backgrounds shared between GNOME and KDE

%description    common
This package includes the common files used by both GNOME and KDE.

%description -l fr common
Ce paquet inclut les fichiers commun à GNOME et KDE

%package        kdm
Group: Graphics
Summary:        Earth-and-moon desktop background for KDM

%description    kdm
Earth-and-moon desktop background used in KDM.

%description -l fr kdm
Ce paquet inclut les fond écrans earth-and-moon qui sont utilisés dans KDM

%package        single
Group: Graphics
Summary:        Extra earth-and-moon desktop background with modern look

%description    single
Earthlooks is beautiful theme. The background change often. You can see earth
rotate on herself and moon rotate around earth. This theme is compatible with
many resolution: 800x600, 1280x1024, 1600x1200, 1680x1050, 1900x1200

%description -l fr single
Earthlooks est un thème magnifique. Les fonds écrans change régulièrement.
Vous pouvez voir la Terre tourner sur elle même et la lune tourne autour de la
Terre. Ce fond écrans sont compatibles dans plusieurs résolution: 800x600,
1280x1024, 1680x1050, 1600x1200, 1900x1200

%package        dual
Group: Graphics
Summary:        Shared dual screen earth-and-moon desktop backgrounds

%description dual
Earthlooks is beautiful theme. The background change often. You can see earth
rotate on herself and moon rotate around earth. This theme is compatible with
many resolution: 2560x1024, 2960x1050, 3200x1200, 3840x1200

%description -l fr dual
Earthlooks est un thème magnifique. Les fonds écrans change régulièrement.
Vous pouvez voir la Terre tourner sur elle même et la lune tourne autour de la
Terre. Ce fond écrans sont compatibles dans plusieurs résolution: 2560x1024,
2960x1050, 3200x1200, 3840x1200


%build


%install

# prepare the dir structure
for RESOLUTION in 800x600 1280x1024 1600x1200 1680x1050 1900x1200 2560x1024 3200x1200 3840x1200;
do mkdir -p %{buildroot}/%{_datadir}/backgrounds/earth-and-moon/$RESOLUTION;
done;
mkdir -p %{buildroot}/%{_datadir}/gnome-background-properties

# copy the earth-and-moon images
cp -a $RPM_BUILD_DIR/%{name}-%{version}/earth-and-moon/{800x600,1280x1024,1600x1200,1680x1050,1900x1200,2560x1024,2960x1050,3200x1200,3840x1200} \
        %{buildroot}/%{_datadir}/backgrounds/earth-and-moon/

# copy slideshow xml files
cp -a $RPM_BUILD_DIR/%{name}-%{version}/earth-and-moon.xml \
        %{buildroot}/%{_datadir}/backgrounds/earth-and-moon
cp -a $RPM_BUILD_DIR/%{name}-%{version}/earth-and-moon-hd.xml \
        %{buildroot}/%{_datadir}/backgrounds/earth-and-moon

# copy metadata xmls file
cp -a $RPM_BUILD_DIR/%{name}-%{version}/desktop-backgrounds-earth-and-moon.xml \
        %{buildroot}/%{_datadir}/gnome-background-properties
cp -a $RPM_BUILD_DIR/%{name}-%{version}/desktop-backgrounds-earth-and-moon-hd.xml \
        %{buildroot}/%{_datadir}/gnome-background-properties



%files
%doc COPYING
%{_datadir}/gnome-background-properties/desktop-backgrounds-earth-and-moon.xml
%{_datadir}/backgrounds/earth-and-moon/earth-and-moon.xml

%files common
%doc COPYING
%dir %{_datadir}/backgrounds/earth-and-moon
%dir %{_datadir}/backgrounds/earth-and-moon/800x600
%dir %{_datadir}/backgrounds/earth-and-moon/1280x1024
%dir %{_datadir}/backgrounds/earth-and-moon/1680x1050
%dir %{_datadir}/backgrounds/earth-and-moon/1600x1200
%dir %{_datadir}/backgrounds/earth-and-moon/1900x1200
%dir %{_datadir}/backgrounds/earth-and-moon/2560x1024
%dir %{_datadir}/backgrounds/earth-and-moon/2960x1050
%dir %{_datadir}/backgrounds/earth-and-moon/3200x1200
%dir %{_datadir}/backgrounds/earth-and-moon/3840x1200
%{_datadir}/backgrounds/earth-and-moon/800x600/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/1280x1024/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/1680x1050/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/1600x1200/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/1900x1200/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/2560x1024/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/2960x1050/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/3200x1200/01.jpeg
%{_datadir}/backgrounds/earth-and-moon/3840x1200/01.jpeg

%files dual
%doc COPYING
%{_datadir}/backgrounds/earth-and-moon/2560x1024
%{_datadir}/backgrounds/earth-and-moon/2960x1050
%{_datadir}/backgrounds/earth-and-moon/3200x1200
%{_datadir}/backgrounds/earth-and-moon/3840x1200
%{_datadir}/gnome-background-properties/desktop-backgrounds-earth-and-moon-hd.xml
%{_datadir}/backgrounds/earth-and-moon/earth-and-moon-hd.xml

%files single
%doc COPYING
%{_datadir}/backgrounds/earth-and-moon/800x600
%{_datadir}/backgrounds/earth-and-moon/1280x1024
%{_datadir}/backgrounds/earth-and-moon/1680x1050
%{_datadir}/backgrounds/earth-and-moon/1600x1200
%{_datadir}/backgrounds/earth-and-moon/1900x1200
%{_datadir}/gnome-background-properties/desktop-backgrounds-earth-and-moon.xml
%{_datadir}/backgrounds/earth-and-moon/earth-and-moon.xml

%files kdm
%doc COPYING
%dir %{_datadir}/backgrounds/earth-and-moon
%dir %{_datadir}/backgrounds/earth-and-moon/1680x1050
%{_datadir}/backgrounds/earth-and-moon/1680x1050/01.jpeg

%changelog
