# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++ qt5-base-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _name   debugger
%define _exe    edb

Name:           edb-debugger
Summary:        A free OllyDbg like debugger
Version:        1.4.0
Release:        alt1_2
Group:          Development/Other
License:        GPLv2
URL:            https://codef00.com/projects
Source0:        https://github.com/eteran/edb-debugger/releases/download/%{version}/%{name}-%{version}.tgz
Patch0:         edb-debugger-plugin_path.patch

ExclusiveArch: %{ix86} x86_64

BuildRequires: pkgconfig(Qt5Concurrent)
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(Qt5Xml)
BuildRequires: pkgconfig(Qt5XmlPatterns)
BuildRequires: pkgconfig(capstone)
BuildRequires: pkgconfig(libgvc)
BuildRequires: libdouble-conversion-devel
BuildRequires: boost-complete >= 1.35
BuildRequires: ccmake cmake ctest
BuildRequires: ImageMagick-tools libImageMagick7.10
Source44: import.info

%description
One of the main goals of this debugger is modularity.
The interface is written in Qt5 and is therefore source portable
to many platforms. The debugger core is a plugin and the platform
specific code is isolated to just a few files, porting to a new OS
would require porting these few files and implementing a plugin
which implements the DebuggerCoreInterface interface. Also,
because the plugins are based on the QPlugin API, and do their work
through the DebuggerCoreInterface object, they are almost always
portable with just a simple recompile.
The disassembly engine is my edisassm project. I feel that this
disassembler is mature and works well. It is worth noting that the
current version of edb has temporarily dropped AT&T syntax support.
Once this is implemented in edisassm, it will return.

%prep
%setup -q -n %{name}
%patch0 -p1


%build
%define _disable_ld_no_undefined 1
%{mageia_cmake_qt5} -DBUILD_SHARED_LIBS=OFF
%mageia_cmake_build

%install
%mageia_cmake_install

desktop-file-install --vendor="" \
		     --dir %{buildroot}%{_datadir}/applications \
                     --remove-category="Qt" \
		     %{_exe}.desktop

#install appdata file
mkdir -p %{buildroot}%{_metainfodir}
install -m 644 %{_exe}.appdata.xml %{buildroot}%{_metainfodir}/%{_exe}.appdata.xml

%files
%doc CHANGELOG README.md
%doc --no-dereference COPYING
%{_bindir}/%{_exe}
%{_libdir}/%{_exe}/
%{_datadir}/applications/%{_exe}.desktop
%{_datadir}/pixmaps/%{_exe}.png
%{_metainfodir}/%{_exe}.appdata.xml
%{_mandir}/man1/%{_exe}.1*


%changelog
