# BEGIN SourceDeps(oneline):
BuildRequires: swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	3D dungeon crawling game
Name:		egoboo
Version:	2.8.1
Release:	alt1_11
Epoch:		1
License:	GPLv3+
Group:		Games/Adventure
URL:		http://egoboo.sourceforge.net/
#Source0:	https://downloads.sourceforge.net/egoboo/%{name}-%{version}.tar.gz
#Since upstream gives both source and data in one tarball, we split it between here and egoboo-data package :
#wget https://downloads.sourceforge.net/egoboo/%{name}-%{version}.tar.gz
#tar xvf %{name}-%{version}.tar.gz
#mkdir %{name}-data-%{version}
#cd %{name}-%{version}
#mv basicdat/ doc/ modules/ egoboo*ico ../%{name}-data-%{version}/
#cd ..
#tar Jcvf %{name}-%{version}.tar.xz %{name}-%{version}/
#tar Jcvf %{name}-data-%{version}.tar.xz %{name}-data-%{version}/
Source0:	%{name}-%{version}.tar.xz
Source1:	%{name}.png
Patch1:		egoboo-2.8.1-mageia-rediff-add-destdir.patch
Patch4:		egoboo-2.8.0-create-enet-lib-directory.patch
Patch6:		egoboo-2.8.0-disable-unsupported-gl-extension.patch
Patch7:		egoboo-2.8.1-mandriva-use-datadir-for-config.patch
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(SDL_mixer)
BuildRequires:	pkgconfig(SDL_ttf)
BuildRequires:	pkgconfig(SDL_image)
BuildRequires:	pkgconfig(glu)
BuildRequires:	ImageMagick-tools
BuildRequires:	pkgconfig(physfs)
Requires:	egoboo-data = %{epoch}:%{version}
Source44: import.info

%description
Egoboo is an open source project, using OpenGL and SDL(Simple
DirectMedia Layer) libraries. It is a 3d dungeon role playing
game in the spirit of NetHack. Nice colorful graphics, and
detailed models(using Quake2 modeling tools) make this game
stand out in the gaming open-source community.

%prep
%setup -q
%patch1 -p1 -b .destdir~
%patch4 -p0 -b .enet_lib~
%patch6 -p1 -b .gl_ext~
%patch7 -p1 
perl -pi.add_lm -e 's/(-l)/-lm $1/ if /^LDFLAGS :=/' game/Makefile

%build
%make_build -C enet OPT='-Wall %{optflags}'
%make_build all OPT='-DPREFIX=\"%{_prefix}\" -D_NIX_PREFIX -Wall %{optflags}'

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop <<EOF
[Desktop Entry]
Name=Egoboo
Comment=A top down graphical (3D) RPG in the spirit of Nethack
Exec=%{_gamesbindir}/egoboo
Icon=egoboo
Terminal=false
StartupNotify=false
Type=Application
Categories=Game;RolePlaying;AdventureGame;
EOF

mkdir -p %{buildroot}/%{_niconsdir}
cp %{SOURCE1} %{buildroot}%_niconsdir/%{name}.png

%files
%doc README.Linux game/change.log
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/controls.txt
%{_gamesdatadir}/%{name}/setup.txt
%{_datadir}/applications/egoboo.desktop
%_niconsdir/%{name}.png




%changelog
