Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Review Request: https://bugzilla.redhat.com/show_bug.cgi?id=1197517

Name:           elmon
Version:        13b1
Release:        alt2_15
Summary:        Performance monitoring tool

License:        GPLv3
URL:            http://elmon.sourceforge.net/
Source0:        http://sourceforge.net/projects/%{name}/files/%{name}_%{version}.tar

BuildRequires:  gcc
BuildRequires:  libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
Source44: import.info

%description
elmon is a performance monitoring tool for Linux. It provides an ncurses
interface as well as the ability to save the data to a CSV file. elmon is based
on nmon by Nigel Griffiths and the CSV output is compatible with nmon processing
tools.

elmon provides performance information on CPU, memory, network, disk, file
system usage, etc.

If you are familiar with nmon, here are the additional features that elmon
supports:
o Multi-column output.
o Interactive Help Menu
o Stat sections are displayed in the order that the user enables them
o Long term CPU graph will use up the entire width of the screen
o Supports subsecond screen refreshes
o New Memory/Swap graph
o Multiple bug fixes (including several bug fixes supplied by David Baril on
nmon forum).


%prep
%setup -q -c %{name}-%{version}


%build
%{make_build} elmon_x86_rhel52


%install
mkdir -p %{buildroot}/%{_bindir}
install elmon_x86_rhel52 %{buildroot}/%{_bindir}/%{name}

%files
%doc change_log.txt
%doc --no-dereference license.txt
%{_bindir}/%{name}


%changelog
