Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/git gcc-c++ perl(Date/Format.pm) perl(MIME/Parser.pm) perl(Time/ParseDate.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Post release snapshot of 3.1.4.
%global commit 283534d97d5a181b09960ae1f0c53dbbe42d8a90
%global shortcommit %(c=%{commit}; echo ${c:0:12})
%global snapinfo 20190113git%{shortcommit}

# We need to include this git submodule, mxml. :(
# It's written by the author of elog; it's _not_ the mxml in Fedora.
%global commit1 cb34fe499c80fcb80aa6e5a2ae7f2dbaf7e790e1
%global shortcommit1 %(c=%{commit1}; echo ${c:0:12})

Name:           elog
Version:        3.1.4
Release:        alt3_7.%{snapinfo}
Summary:        Logbook system to manage notes through a Web interface

License:        GPLv2 and GPLv3+
URL:            https://midas.psi.ch/elog/
Source0:        https://bitbucket.org/ritt/elog/get/%{commit}.tar.gz#/%{name}-%{shortcommit}.tar.gz

Source1:        elogd.service

# elog "mxml" library.
# Remove if we move away from bitbucket snapshot.
Source2:        https://bitbucket.org/tmidas/mxml/get/%{commit1}.tar.gz#/%{name}-mxml-%{shortcommit1}.tar.gz

# Patch for the makefile.
Patch0:         https://tc01.fedorapeople.org/elog/elog-makefile-elogdir.patch

BuildRequires:  gcc
BuildRequires:  glibc-devel glibc-devel-static, libssl-devel libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils, ckeditor, dos2unix glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  libkrb5-devel, libldap-devel

# JavaScript that we're unbundling.
Requires:       ckeditor

# Require the subpackage.
Requires:       elog-client

Requires(pre):  shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Source44: import.info

%description
ELOG is part of a family of applications known as weblogs. Their general
purpose is:

1. To make it easy for people to put information online in a chronological
fashion, in the form of short, time-stamped text messages ("entries") with
optional HTML markup for presentation, and optional file attachments
(images, archives, etc.)

2. To make it easy for other people to access this information through a
Web interface, browse entries, search, download files, and optionally add,
update, delete or comment on entries.

ELOG is a remarkable implementation of a weblog in at least two respects:

1. Its simplicity of use: you don't need to be a seasoned server operator
and/or an experimented database administrator to run ELOG ; one executable
file (under Unix or Windows), a simple configuration text file, and it works.
No Web server or relational database required. It is also easy to translate
the interface to the appropriate language for your users.

2. Its versatility: through its single configuration file, ELOG can be made
to display an infinity of variants of the weblog concept. There are options
for what to display, how to display it, what commands are available and to
whom, access control, etc. Moreover, a single server can host several
weblogs, and each weblog can be totally different from the rest.

%package client
Group: Other

Summary:        CLI client for the ELOG logbook system


%description client

This package contains only the "elog" client binary, for communicating
with an ELOG logbook. See the description of the "elog" package for more
information.

%package doc
Group: Other

Summary:        ELOG documentation
BuildArch:      noarch

%description doc

This package contains the documentation for the ELOG logbook server.
See the description of the "elog" package for more information.

%prep
%setup -q -n ritt-elog-%{shortcommit}
%patch0 -p1


# Various fixes; remove executable bits, remove bundled ckeditor.
rm -rf scripts/ckeditor

cd scripts && find . -type f -print0 | xargs -0 chmod a-x && cd ..
chmod a-x COPYING

#rm doc/index.html~
cd doc && find . -type f -print0 | xargs -0 chmod a-x && cd ..
dos2unix doc/strftime.txt
iconv -f latin1 -t utf-8 doc/strftime.txt > doc/strftime.txt.conv
mv -f doc/strftime.txt.conv doc/strftime.txt

# Fix some spurious executable permissions.
chmod -x src/elog.c
chmod -x src/regex.h
chmod -x src/regex.c
chmod -x src/elogd.c

# We need to drop source1 into the "mxml" directory.
# I'm sure this _could_ be done with a version of the setup macro...
tar xfz %SOURCE2 -C mxml --strip-components=1

%build
%make_build CFLAGS="%{optflags} -Imxml -DHAVE_SSL -DHAVE_KRB5 -DHAVE_LDAP" LIBS="%{__global_ldflags} -lssl -lkrb5 -lldap -llber"

%install
# This makefile needs a fair amount of massaging to do the right thing.
# Hence the above patch.
make install ROOT=%{buildroot} PREFIX=%{_prefix} MANDIR=%{buildroot}%{_mandir} ELOGDIR=%{buildroot}%{_datadir}/elog
rm %{buildroot}%{_initddir}/elogd

# Move the configuration file to the right place.
mv %{buildroot}%{_datadir}/elog/elogd.cfg %{buildroot}%{_sysconfdir}/

# Land the systemd initscript.
mkdir -p %{buildroot}%{_unitdir}
cp %SOURCE1 %{buildroot}%{_unitdir}

# Create the local state directory for logbooks.
mkdir -p %{buildroot}%{_localstatedir}/lib/elog/logbooks

# replace bundled ckeditor with a symlink.
ln -s %{_datadir}/ckeditor %{buildroot}%{_datadir}/elog/scripts/ckeditor

# Create elog user/group.
%pre
getent group elog > /dev/null || groupadd -r elog
getent passwd elog  > /dev/null || \
    useradd -r -g elog -d /usr/share/elog -s /sbin/nologin \
    -c "ELOG logbook daemon user" elog
exit 0

# Systemd snippets for elogd service file

%post
%post_service elogd

%preun
%preun_service elogd

%files
%{_bindir}/elconv
%{_sbindir}/elogd
%{_datadir}/elog/
%{_mandir}/man1/elconv.1*
%{_mandir}/man8/elogd.8*
%{_unitdir}/elogd.service

# The directory for a user's logbooks.
%dir %attr(-,elog,elog) %{_localstatedir}/lib/elog
%dir %attr(-,elog,elog) %{_localstatedir}/lib/elog/logbooks

# Configuration for elogd.
%config(noreplace) %{_sysconfdir}/elogd.cfg

%doc README
%doc --no-dereference COPYING

%files client
%{_bindir}/elog
%{_mandir}/man1/elog.1*
%doc --no-dereference COPYING

%files doc
%doc doc/

%changelog
