# BEGIN SourceDeps(oneline):
BuildRequires: python-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name etrophy
%define version 0.5.1
%define option  0
%define svn     0
%define rel     9
%if %option
%define orel 0.%option.%{rel}
%define namevers %name-%version-%option
%else
%define orel %{rel}
%define namevers %name-%version
%endif
%if %svn
%define release %mkrel -c %svn %orel
%else
%define release %mkrel %orel
%endif

%define major      0
%define libname    lib%{name}%{major}
%define libnamedev lib%{name}-devel

Summary:        Library that manages scores, trophies and unlockables
Name:           etrophy
Version:        0.5.1
Release:        alt1_9
License:        LGPLv2+
Group:          Graphical desktop/Enlightenment
# creating archive is quite simple:
# svn export http://svn.enlightenment.org/svn/e/branches/%%name-1.1 %%name
# tar cJf %%name-%%svn.tar.xz %%name
%if %svn
Source:         %name-%svn.tar.xz
%else
Source:         http://download.enlightenment.org/releases/%namevers.tar.bz2
%endif
URL:            http://trac.enlightenment.org/e/wiki/Eina

BuildRequires:  efl-libs efl-libs-devel elementary-data libelementary libelementary-devel
BuildRequires:  pkgconfig(efl)
BuildRequires:  doxygen
BuildRequires:  python3 python3-tools
Source44: import.info

%description
Etrophy is a library that manages scores, trophies and unlockables. 
It will store them and provide views to display them. It could be 
used by games based on EFL and any other application where such a 
thing could make sense.

%package -n %libname
Summary:        Libraries for the %{name} package
Group:          System/Libraries

%description -n %libname
Libraries for %{name}.

%package -n %libnamedev
Summary:        Headers and development libraries from %{name}
Group:          Development/Other
Requires:       %libname = %{version}-%{release}
Provides:       lib%{name}-devel = %{version}-%{release}
Provides:       %name-devel = %{version}-%{release}

%description -n %libnamedev
%{name} development headers and libraries.

%prep
%if %svn
%setup -qn %name
%else
%setup -qn %namevers
%endif

%build
%if %svn
LC_ALL=C NOCONFIGURE=1 ./autogen.sh
%endif
%configure --disable-static
%make_build

%install
%makeinstall_std

find %buildroot -name '*.la' -delete

%files
%doc AUTHORS README
%dir %{_datadir}/%name
%{_datadir}/%name/%name.edj

%files -n %libname
%{_libdir}/*.so.%{major}
%{_libdir}/*.so.%{major}.*

%files -n %libnamedev
%{_libdir}/pkgconfig/*
%{_libdir}/*.so
%{_includedir}/*


%changelog
